/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.fastq;

import edu.unc.bioinf.ubu.fastq.FastqRecord;
import edu.unc.bioinf.ubu.util.QualityConverter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FastqInputFile {
    private static final int CACHING_DISABLED = -1;
    private BufferedReader reader;
    private Map<Integer, FastqRecord> records = new HashMap<Integer, FastqRecord>();
    private int recordNum = 0;
    private int maxCachedLines;
    private QualityConverter qualityConverter = new QualityConverter();

    public void init(String filename, int maxCachedLines) throws FileNotFoundException {
        this.openFile(filename);
        this.maxCachedLines = maxCachedLines;
    }

    public void init(String filename) throws FileNotFoundException {
        this.init(filename, -1);
    }

    private void openFile(String filename) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(filename));
    }

    public FastqRecord getNextRecord() throws IOException {
        String[] lines = new String[4];
        for (int i = 0; i < 4; ++i) {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            lines[i] = line;
        }
        FastqRecord fastqRecord = new FastqRecord(lines);
        fastqRecord.setQualityConverter(this.qualityConverter);
        return fastqRecord;
    }

    public FastqRecord getRecord(int idx) throws IOException {
        if (this.isCachingDisabled()) {
            throw new UnsupportedOperationException("Retrieving record by index not supported when caching is disabled.");
        }
        if (idx < 1) {
            throw new IllegalArgumentException("Read index cannot be less than 1.  Index: [" + idx + "]");
        }
        FastqRecord record = null;
        if (this.records.containsKey(idx)) {
            return this.records.get(idx);
        }
        if (idx <= this.recordNum) {
            throw new UnsupportedOperationException("Cannot read back to an uncached record. Index: [" + idx + "]");
        }
        while (idx > this.recordNum) {
            record = this.getNextRecord();
            ++this.recordNum;
            this.records.put(this.recordNum, record);
            this.records.remove(this.recordNum - this.maxCachedLines);
        }
        assert (this.records.size() <= this.maxCachedLines);
        return record;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private boolean isCachingDisabled() {
        return this.maxCachedLines == -1;
    }
}

