/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.GenomeToTranscriptomeConverter;
import edu.unc.bioinf.ubu.sam.GenomeToTranscriptomeOptions;
import edu.unc.bioinf.ubu.sam.IsoformIndex;
import edu.unc.bioinf.ubu.sam.IsoformOrderLoader;
import java.util.Date;

public class GenomeToTranscriptome {
    public static void main(String[] args) throws Exception {
        GenomeToTranscriptome.run(args);
        System.out.println("mem: " + Runtime.getRuntime().totalMemory());
    }

    public static void run(String[] args) throws Exception {
        System.out.println("Starting " + new Date());
        long s = System.currentTimeMillis();
        System.out.println("Parsing arguments");
        GenomeToTranscriptomeOptions options = new GenomeToTranscriptomeOptions();
        options.parseOptions(args);
        if (options.isValid()) {
            System.out.println(GenomeToTranscriptome.getAllArgsString(options));
            IsoformOrderLoader isoformOrderLoader = null;
            if (options.hasOrderingFastaFile()) {
                System.out.println("Determining isoform header order");
                isoformOrderLoader = new IsoformOrderLoader();
                isoformOrderLoader.loadOrdering(options.getOrderingFastaFile());
            } else {
                System.out.println("Skipping isoform header order determination");
            }
            System.out.println("Building read index");
            IsoformIndex isoformIndex = new IsoformIndex();
            isoformIndex.buildReadToIsoformIndex(options.getBedFile(), options.getReadOffset());
            System.out.println("Converting");
            GenomeToTranscriptomeConverter converter = new GenomeToTranscriptomeConverter(isoformIndex, isoformOrderLoader, options.isSingleEnd());
            converter.setPositiveStrandReportingOnly(options.isPositiveStrandReportingOnly());
            converter.setShouldOutputXgTags(options.shouldOutputXgTags());
            converter.convertFile(options.getInputAlignmentFile(), options.getOutputAlignmentFile());
            long e = System.currentTimeMillis();
            System.out.println("Finished: " + new Date());
            System.out.println("Elapsed seconds: " + (e - s) / 1000L);
        }
    }

    private static String getAllArgsString(GenomeToTranscriptomeOptions options) {
        StringBuffer buf = new StringBuffer();
        buf.append("bedFile: " + options.getBedFile() + "\n");
        buf.append("readOffset: " + options.getReadOffset() + "\n");
        buf.append("inputAlignmentFile: " + options.getInputAlignmentFile() + "\n");
        buf.append("outputAlignmentFile: " + options.getOutputAlignmentFile() + "\n");
        if (options.hasOrderingFastaFile()) {
            buf.append("orderFastaFile: " + options.getOrderingFastaFile() + "\n");
        } else {
            buf.append("orderFastaFile: not specified\n");
        }
        buf.append("positiveStrandReportingOnly: " + options.isPositiveStrandReportingOnly() + "\n");
        buf.append("xgtags: " + options.shouldOutputXgTags() + "\n");
        buf.append("single: " + options.isSingleEnd() + "\n");
        return buf.toString();
    }
}

