/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RsemExpectedCountsAggregator {
    private List<RsemFileInfo> fileInfo = new ArrayList<RsemFileInfo>();
    private BufferedWriter writer;
    private List<BufferedReader> readers = new ArrayList<BufferedReader>();
    private int lineNum = 1;
    private String countFile;

    public void aggregate(String countFile, String outputFile, List<String> directories) throws IOException {
        this.countFile = countFile;
        this.writer = new BufferedWriter(new FileWriter(outputFile, false));
        this.findRsemFiles(directories);
        this.buildMatrix();
        this.writer.close();
        this.closeReaders();
    }

    private void closeReaders() throws IOException {
        for (BufferedReader reader : this.readers) {
            reader.close();
        }
    }

    private void buildMatrix() throws IOException {
        this.initReaders();
        this.writeHeader();
        this.processFiles();
    }

    private List<String> getNextResultList() throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        boolean isNullInResults = false;
        boolean isNonNullInResults = false;
        for (BufferedReader reader : this.readers) {
            String line = reader.readLine();
            if (line == null) {
                isNullInResults = true;
            }
            if (line != null) {
                isNonNullInResults = true;
            }
            results.add(line);
        }
        if (isNullInResults && isNonNullInResults) {
            throw new IllegalArgumentException("Invalid EOF reached at line: " + this.lineNum);
        }
        ++this.lineNum;
        if (isNullInResults) {
            results = null;
        }
        return results;
    }

    private void processFiles() throws IOException {
        List<String> lines = this.getNextResultList();
        while (lines != null) {
            if (this.containsNonZeroCount(lines)) {
                this.outputCount(lines);
            }
            lines = this.getNextResultList();
        }
    }

    private boolean containsNonZeroCount(List<String> lines) {
        double totalCount = 0.0;
        for (String line : lines) {
            String[] fields = line.split("\t");
            String countStr = fields[1];
            totalCount += Double.valueOf(countStr).doubleValue();
        }
        boolean isNonZero = false;
        if (Math.abs(totalCount) > 1.0E-4) {
            isNonZero = true;
        }
        return isNonZero;
    }

    private void outputCount(List<String> lines) throws IOException {
        StringBuffer geneLine = new StringBuffer();
        String firstLine = lines.get(0);
        String[] fields = firstLine.split("\t");
        String geneId = fields[0];
        geneLine.append(geneId);
        for (String line : lines) {
            String[] lineFields = line.split("\t");
            String currGeneId = lineFields[0];
            if (!currGeneId.equals(geneId)) {
                throw new IllegalArgumentException("Mismatch genes: " + geneId + " - " + currGeneId);
            }
            String expectedCount = lineFields[1];
            geneLine.append('\t');
            geneLine.append(expectedCount);
        }
        this.writer.write(geneLine.toString());
        this.writer.write(10);
    }

    private void initReaders() throws IOException {
        for (RsemFileInfo info : this.fileInfo) {
            this.readers.add(new BufferedReader(new FileReader(info.getGeneFile())));
        }
    }

    private void writeHeader() throws IOException {
        StringBuffer str = new StringBuffer();
        for (RsemFileInfo info : this.fileInfo) {
            str.append('\t');
            str.append(info.getSampleId());
        }
        this.writer.write(str.toString());
        this.writer.write(10);
    }

    private void findRsemFiles(List<String> directories) {
        for (String directory : directories) {
            File[] filesInDir;
            System.out.println("Processing directory: " + directory);
            File file = new File(directory);
            for (File fileInDir : filesInDir = file.listFiles()) {
                if (!fileInDir.isDirectory()) continue;
                System.out.println("Adding: " + fileInDir.getName());
                this.fileInfo.add(new RsemFileInfo(fileInDir.getName(), fileInDir.getAbsolutePath() + "/" + this.countFile, fileInDir.getAbsolutePath() + "/" + "foo"));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.println("RsemExpectedCountsAggregator <results_file_name> <output_file> <dir1> <dir2> ... <dirn>");
            System.exit(0);
        }
        String countFile = args[0];
        String outputFile = args[1];
        ArrayList<String> directories = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            directories.add(args[i]);
        }
        RsemExpectedCountsAggregator aggregator = new RsemExpectedCountsAggregator();
        aggregator.aggregate(countFile, outputFile, directories);
    }

    static class RsemFileInfo {
        private String sampleId;
        private String geneFile;
        private String isoformFile;

        RsemFileInfo(String sampleId, String geneFile, String isoformFile) {
            this.sampleId = sampleId;
            this.geneFile = geneFile;
            this.isoformFile = isoformFile;
        }

        public String getSampleId() {
            return this.sampleId;
        }

        public String getGeneFile() {
            return this.geneFile;
        }

        public String getIsoformFile() {
            return this.isoformFile;
        }
    }
}

