/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.util.Options;
import joptsimple.OptionParser;

public class SamConverterOptions
extends Options {
    private static final String INPUT = "in";
    private static final String OUTPUT = "out";
    private static final String PHRED64_TO_PHRED33 = "phred64to33";
    private OptionParser parser;
    private boolean isValid;

    @Override
    protected OptionParser getOptionParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.parser.accepts(INPUT, "Input SAM/BAM file").withRequiredArg().ofType(String.class);
            this.parser.accepts(OUTPUT, "Output SAM/BAM file").withRequiredArg().ofType(String.class);
            this.parser.accepts(PHRED64_TO_PHRED33, "If specified, convert quality score from phred64 to phred33");
            this.parser.accepts("help", "Print this help message");
        }
        return this.parser;
    }

    @Override
    protected void validate() {
        this.isValid = true;
        if (!this.getOptions().hasArgument(INPUT)) {
            this.isValid = false;
            System.err.println("Missing required input SAM/BAM file");
        }
        if (!this.getOptions().hasArgument(OUTPUT)) {
            this.isValid = false;
            System.err.println("Missing required output SAM/BAM file");
        }
        if (!this.getOptions().has(PHRED64_TO_PHRED33)) {
            this.isValid = false;
            System.err.println("No conversion options specified.");
        }
        if (!this.isValid) {
            this.printHelp();
        }
    }

    public String getInputFile() {
        return (String)this.getOptions().valueOf(INPUT);
    }

    public String getOutputFile() {
        return (String)this.getOptions().valueOf(OUTPUT);
    }

    public boolean shouldConvertPhred64toPhred33() {
        return this.getOptions().has(PHRED64_TO_PHRED33);
    }

    public boolean isValid() {
        return this.isValid;
    }
}

