/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class SamMultiMappingReader
implements Iterable<List<SAMRecord>> {
    private SAMFileReader inputSam;
    private Iterator<SAMRecord> iter;
    private SAMRecord cachedRead;
    private int numRecords = 0;

    public SamMultiMappingReader(String filename) {
        File inputFile = new File(filename);
        this.inputSam = new SAMFileReader(inputFile);
        this.inputSam.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.iter = this.inputSam.iterator();
    }

    public SAMFileHeader getFileHeader() {
        return this.inputSam.getFileHeader();
    }

    private boolean hasMoreReads() {
        return this.cachedRead != null || this.iter.hasNext();
    }

    private SAMRecord getNextRead() {
        SAMRecord read = null;
        if (this.cachedRead != null) {
            read = this.cachedRead;
            this.cachedRead = null;
        } else {
            read = this.iter.next();
            ++this.numRecords;
            if (this.numRecords % 1000000 == 0) {
                System.out.println("Processed: " + this.numRecords + " records.");
            }
        }
        return read;
    }

    private List<SAMRecord> getNextReadList() {
        ArrayList<SAMRecord> reads = new ArrayList<SAMRecord>();
        SAMRecord read = null;
        String readName = null;
        if (this.hasMoreReads()) {
            read = this.getNextRead();
            readName = read.getReadName();
            reads.add(read);
            while (this.hasMoreReads() && read.getReadName().equals(readName)) {
                read = this.getNextRead();
                if (!read.getReadName().equals(readName)) continue;
                reads.add(read);
            }
            if (!read.getReadName().equals(readName)) {
                this.cachedRead = read;
            }
        }
        return reads;
    }

    @Override
    public Iterator<List<SAMRecord>> iterator() {
        return new SamMultiMappingIterator(this);
    }

    private static class SamMultiMappingIterator
    implements Iterator<List<SAMRecord>> {
        private SamMultiMappingReader reader;

        SamMultiMappingIterator(SamMultiMappingReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            return this.reader.hasMoreReads();
        }

        @Override
        public List<SAMRecord> next() {
            return this.reader.getNextReadList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported for SamMultiMappingIterator.");
        }
    }
}

