/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.source;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.index.Index;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broad.tribble.source.BasicFeatureSource;

public class PerformanceLoggingFeatureSource<T extends Feature>
extends BasicFeatureSource<T> {
    private static final Logger log = Logger.getLogger("PerformanceLoggingFeatureSource");
    int nSkipsFromLastQuery;
    int nTotalSkips;
    int nEmptyLines;
    int nRecordsRead;
    int nQueries;

    public PerformanceLoggingFeatureSource(String featureFile, Index indexInstance, FeatureCodec codec) throws IOException {
        super(featureFile, indexInstance, codec);
    }

    public PerformanceLoggingFeatureSource(String featureFile, String indexFile, FeatureCodec codec) throws IOException {
        super(featureFile, indexFile, codec);
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        this.nSkipsFromLastQuery = 0;
        return new TrackingIteratorImpl(this, chr, start, end);
    }

    public int getnSkipsFromLastQuery() {
        return this.nSkipsFromLastQuery;
    }

    public int getnTotalSkips() {
        return this.nTotalSkips;
    }

    public int getnEmptyLines() {
        return this.nEmptyLines;
    }

    public int getnRecordsRead() {
        return this.nRecordsRead;
    }

    public String getPerformanceLog() {
        int nReads = this.nRecordsRead + this.nTotalSkips + this.nEmptyLines;
        return String.format("nQueries %d nRequestedRecords %d nTotalSkips %d efficiency %.2f", this.nQueries, this.nRecordsRead, this.nEmptyLines + this.nTotalSkips, (double)this.nRecordsRead / (0.01 * (double)Math.max(nReads, 1)));
    }

    public class TrackingIteratorImpl<T extends Feature>
    extends BasicFeatureSource.IteratorImpl<T> {
        PerformanceLoggingFeatureSource<T> performanceTrackingSource;

        TrackingIteratorImpl(PerformanceLoggingFeatureSource<T> featureSource, String sequence, int start, int end) throws IOException {
            super(featureSource, sequence, start, end);
            ++PerformanceLoggingFeatureSource.this.nQueries;
            this.performanceTrackingSource = featureSource;
        }

        @Override
        public T next() {
            ++PerformanceLoggingFeatureSource.this.nRecordsRead;
            return (T)super.next();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }

        @Override
        protected void advanceToFirstRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && this.reader != null && (nextLine = this.reader.readLine()) != null) {
                Feature f = this.basicFeatureSource.codec.decodeLoc(nextLine);
                if (f == null) {
                    ++PerformanceLoggingFeatureSource.this.nTotalSkips;
                    ++PerformanceLoggingFeatureSource.this.nEmptyLines;
                    continue;
                }
                if (!f.getChr().equals(this.chr)) {
                    ++PerformanceLoggingFeatureSource.this.nTotalSkips;
                    ++PerformanceLoggingFeatureSource.this.nSkipsFromLastQuery;
                    this.currentRecord = null;
                    break;
                }
                if (f.getEnd() >= this.start) {
                    ++PerformanceLoggingFeatureSource.this.nRecordsRead;
                    this.currentRecord = this.basicFeatureSource.codec.decode(nextLine);
                    break;
                }
                ++PerformanceLoggingFeatureSource.this.nTotalSkips;
                ++PerformanceLoggingFeatureSource.this.nSkipsFromLastQuery;
            }
        }
    }
}

