/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata.utils;

import net.sf.samtools.util.CloseableIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class FeatureToGATKFeatureIterator
implements CloseableIterator<GATKFeature> {
    private final GenomeLocParser genomeLocParser;
    private final CloseableTribbleIterator<Feature> iterator;
    private final String name;

    public FeatureToGATKFeatureIterator(GenomeLocParser genomeLocParser, CloseableTribbleIterator<Feature> iter, String name) {
        this.genomeLocParser = genomeLocParser;
        this.name = name;
        this.iterator = iter;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public GATKFeature next() {
        return new GATKFeature.TribbleGATKFeature(this.genomeLocParser, (Feature)this.iterator.next(), this.name);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Why does Iterator have this method? We always throw an exception here");
    }

    @Override
    public void close() {
    }
}

