/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Gather;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.walkers.bqsr.Covariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDataManager;
import org.broadinstitute.sting.gatk.walkers.recalibration.CountCovariatesGatherer;

public class RecalibrationArgumentCollection {
    @Input(fullName="knownSites", shortName="knownSites", doc="A database of known polymorphic sites to skip over in the recalibration algorithm", required=false)
    protected List<RodBinding<Feature>> knownSites = Collections.emptyList();
    @Gather(value=CountCovariatesGatherer.class)
    @Output
    protected PrintStream RECAL_FILE;
    @Argument(fullName="list", shortName="ls", doc="List the available covariates and exit", required=false)
    protected boolean LIST_ONLY = false;
    @Argument(fullName="covariate", shortName="cov", doc="Covariates to be used in the recalibration. Each covariate is given as a separate cov parameter. ReadGroup and ReportedQuality are required covariates and are already added for you.", required=false)
    protected String[] COVARIATES = null;
    @Argument(fullName="standard_covs", shortName="standard", doc="Use the standard set of covariates in addition to the ones listed using the -cov argument", required=false)
    protected boolean USE_STANDARD_COVARIATES = true;
    @Hidden
    @Argument(fullName="run_without_dbsnp_potentially_ruining_quality", shortName="run_without_dbsnp_potentially_ruining_quality", required=false, doc="If specified, allows the recalibrator to be used without a dbsnp rod. Very unsafe and for expert users only.")
    protected boolean RUN_WITHOUT_DBSNP = false;
    protected final RecalDataManager dataManager = new RecalDataManager();
    protected final ArrayList<Covariate> requestedCovariates = new ArrayList();
    protected final String SKIP_RECORD_ATTRIBUTE = "SKIP";
    protected final String SEEN_ATTRIBUTE = "SEEN";
    @Argument(fullName="solid_recal_mode", shortName="sMode", required=false, doc="How should we recalibrate solid bases in which the reference was inserted? Options = DO_NOTHING, SET_Q_ZERO, SET_Q_ZERO_BASE_N, or REMOVE_REF_BIAS")
    public RecalDataManager.SOLID_RECAL_MODE SOLID_RECAL_MODE = RecalDataManager.SOLID_RECAL_MODE.SET_Q_ZERO;
    @Argument(fullName="solid_nocall_strategy", shortName="solid_nocall_strategy", doc="Defines the behavior of the recalibrator when it encounters no calls in the color space. Options = THROW_EXCEPTION, LEAVE_READ_UNRECALIBRATED, or PURGE_READ", required=false)
    public RecalDataManager.SOLID_NOCALL_STRATEGY SOLID_NOCALL_STRATEGY = RecalDataManager.SOLID_NOCALL_STRATEGY.THROW_EXCEPTION;
    @Argument(fullName="mismatches_context_size", shortName="mcs", doc="size of the k-mer context to be used for base mismatches", required=false)
    public int MISMATCHES_CONTEXT_SIZE = 2;
    @Argument(fullName="insertions_context_size", shortName="ics", doc="size of the k-mer context to be used for base insertions", required=false)
    public int INSERTIONS_CONTEXT_SIZE = 8;
    @Argument(fullName="deletions_context_size", shortName="dcs", doc="size of the k-mer context to be used for base deletions", required=false)
    public int DELETIONS_CONTEXT_SIZE = 8;
    @Argument(fullName="mismatches_default_quality", shortName="mdq", doc="default quality for the base mismatches covariate", required=false)
    public byte MISMATCHES_DEFAULT_QUALITY = (byte)-1;
    @Argument(fullName="insertions_default_quality", shortName="idq", doc="default quality for the base insertions covariate", required=false)
    public byte INSERTIONS_DEFAULT_QUALITY = (byte)45;
    @Argument(fullName="deletions_default_quality", shortName="ddq", doc="default quality for the base deletions covariate", required=false)
    public byte DELETIONS_DEFAULT_QUALITY = (byte)45;
    @Hidden
    @Argument(fullName="default_platform", shortName="dP", required=false, doc="If a read has no platform then default to the provided String. Valid options are illumina, 454, and solid.")
    public String DEFAULT_PLATFORM = null;
    @Hidden
    @Argument(fullName="force_platform", shortName="fP", required=false, doc="If provided, the platform of EVERY read will be forced to be the provided String. Valid options are illumina, 454, and solid.")
    public String FORCE_PLATFORM = null;
}

