/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.recalibration.ExperimentalCovariate;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class HomopolymerCovariate
implements ExperimentalCovariate {
    private int numBack;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.numBack = RAC.HOMOPOLYMER_NBACK;
    }

    private Comparable getValue(SAMRecord read, int offset) {
        int iii;
        int numAgree;
        byte[] bases = read.getReadBases();
        if (!read.getReadNegativeStrandFlag()) {
            for (iii = offset; iii <= bases.length - 2 && bases[iii] == bases[iii + 1] && numAgree < this.numBack; ++numAgree, ++iii) {
            }
        } else {
            for (numAgree = 0; iii >= 1 && bases[iii] == bases[iii - 1] && numAgree < this.numBack; ++numAgree, --iii) {
            }
        }
        return Integer.valueOf(numAgree);
    }

    @Override
    public void getValues(GATKSAMRecord read, Comparable[] comparable) {
        for (int iii = 0; iii < read.getReadLength(); ++iii) {
            comparable[iii] = this.getValue(read, iii);
        }
    }

    @Override
    public final Comparable getValue(String str) {
        return Integer.valueOf(Integer.parseInt(str));
    }
}

