/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.ReadProperties;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReadView;
import org.broadinstitute.sting.gatk.datasources.providers.View;
import org.broadinstitute.sting.gatk.iterators.LocusIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public abstract class LocusView
extends LocusIterator
implements View {
    protected GenomeLoc locus;
    protected GenomeLocParser genomeLocParser;
    private ReadProperties sourceInfo;
    private LocusIterator loci;
    private AlignmentContext nextLocus = null;

    public LocusView(LocusShardDataProvider provider) {
        this.locus = provider.getLocus();
        this.sourceInfo = provider.getSourceInfo();
        this.genomeLocParser = provider.getGenomeLocParser();
        this.loci = provider.getLocusIterator();
        this.advance();
        provider.register(this);
    }

    @Override
    public Collection<Class<? extends View>> getConflictingViews() {
        return Arrays.asList(LocusView.class, ReadView.class);
    }

    @Override
    public void close() {
        this.locus = null;
        this.sourceInfo = null;
        this.loci = null;
        super.close();
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract AlignmentContext next();

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unable to remove elements from this queue.");
    }

    protected boolean hasNextLocus() {
        this.advance();
        return this.nextLocus != null;
    }

    protected AlignmentContext nextLocus() {
        this.advance();
        if (this.nextLocus == null) {
            throw new NoSuchElementException("No more elements remain in locus context queue.");
        }
        AlignmentContext current = this.nextLocus;
        if (this.sourceInfo.getDownsamplingMethod().type == DownsampleType.ALL_READS && this.sourceInfo.getDownsamplingMethod().toCoverage != null) {
            current.downsampleToCoverage(this.sourceInfo.getDownsamplingMethod().toCoverage);
        }
        this.nextLocus = null;
        return current;
    }

    private void advance() {
        if (this.nextLocus != null) {
            return;
        }
        if (!this.loci.hasNext()) {
            this.nextLocus = null;
            return;
        }
        this.nextLocus = this.loci.next();
        if (this.locus != null) {
            while (this.nextLocus != null && !this.isContainedInShard(this.nextLocus.getLocation()) && this.loci.hasNext()) {
                this.nextLocus = this.loci.next();
            }
            if (this.nextLocus != null && !this.isContainedInShard(this.nextLocus.getLocation())) {
                this.nextLocus = null;
            }
        }
    }

    private boolean isContainedInShard(GenomeLoc location) {
        return this.locus.containsP(location);
    }
}

