/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class PileupElement
implements Comparable<PileupElement> {
    public static final byte DELETION_BASE = 68;
    public static final byte DELETION_QUAL = 16;
    public static final byte A_FOLLOWED_BY_INSERTION_BASE = 87;
    public static final byte C_FOLLOWED_BY_INSERTION_BASE = 88;
    public static final byte T_FOLLOWED_BY_INSERTION_BASE = 89;
    public static final byte G_FOLLOWED_BY_INSERTION_BASE = 90;
    protected final GATKSAMRecord read;
    protected final int offset;

    @Requires(value={"read != null", "offset >= -1", "offset <= read.getReadLength()"})
    public PileupElement(GATKSAMRecord read, int offset) {
        this.read = read;
        this.offset = offset;
    }

    public boolean isDeletion() {
        return this.offset == -1;
    }

    @Ensures(value={"result != null"})
    public GATKSAMRecord getRead() {
        return this.read;
    }

    @Ensures(value={"result == offset"})
    public int getOffset() {
        return this.offset;
    }

    public byte getBase() {
        return this.getBase(this.offset);
    }

    public int getBaseIndex() {
        return this.getBaseIndex(this.offset);
    }

    public byte getQual() {
        return this.getQual(this.offset);
    }

    public int getMappingQual() {
        return this.read.getMappingQuality();
    }

    @Ensures(value={"result != null"})
    public String toString() {
        return String.format("%s @ %d = %c Q%d", this.getRead().getReadName(), this.getOffset(), Character.valueOf((char)this.getBase()), this.getQual());
    }

    protected byte getBase(int offset) {
        return this.isDeletion() ? (byte)68 : this.read.getReadBases()[offset];
    }

    protected int getBaseIndex(int offset) {
        return BaseUtils.simpleBaseToBaseIndex(this.isDeletion() ? (byte)68 : this.read.getReadBases()[offset]);
    }

    protected byte getQual(int offset) {
        return this.isDeletion() ? (byte)16 : this.read.getBaseQualities()[offset];
    }

    @Override
    public int compareTo(PileupElement pileupElement) {
        if (this.offset < pileupElement.offset) {
            return -1;
        }
        if (this.offset > pileupElement.offset) {
            return 1;
        }
        if (this.read.getAlignmentStart() < pileupElement.read.getAlignmentStart()) {
            return -1;
        }
        if (this.read.getAlignmentStart() > pileupElement.read.getAlignmentStart()) {
            return 1;
        }
        return 0;
    }

    public boolean isReducedRead() {
        return this.read.isReducedRead();
    }

    public int getRepresentativeCount() {
        return !this.isDeletion() && this.isReducedRead() ? (int)this.read.getReducedCount(this.offset) : 1;
    }
}

