/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;

class RodBindingArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    RodBindingArgumentTypeDescriptor() {
    }

    @Override
    public boolean supports(Class type) {
        return RodBindingArgumentTypeDescriptor.isRodBinding(type);
    }

    public static boolean isRodBinding(Class type) {
        return RodBinding.class.isAssignableFrom(type);
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return !source.isRequired();
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        return RodBinding.makeUnbound(parameterType);
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "none";
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        return this.parse(parsingEngine, source, type, matches, false);
    }

    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches, boolean createIntervalBinding) {
        ArgumentDefinition defaultDefinition = this.createDefaultArgumentDefinition(source);
        String value = this.getArgumentValue(defaultDefinition, matches);
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        try {
            Object result;
            String name = defaultDefinition.fullName;
            String tribbleType = null;
            Tags tags = this.getArgumentTags(matches);
            if (tags.getPositionalTags().size() > 2) {
                throw new UserException.CommandLineException(String.format("Unexpected number of positional tags for argument %s : %s. Rod bindings only support -X:type and -X:name,type argument styles", value, source.field.getName()));
            }
            if (tags.getPositionalTags().size() == 2) {
                name = tags.getPositionalTags().get(0);
                tribbleType = tags.getPositionalTags().get(1);
            } else {
                String tag1;
                FeatureManager manager = new FeatureManager();
                String string = tag1 = tags.getPositionalTags().size() == 1 ? tags.getPositionalTags().get(0) : null;
                if (tag1 != null) {
                    if (manager.getByName(tag1) != null) {
                        tribbleType = tag1;
                    } else {
                        name = tag1;
                    }
                }
                if (tribbleType == null) {
                    FeatureManager.FeatureDescriptor featureDescriptor;
                    File file = new File(value);
                    if (file.canRead() && file.isFile() && (featureDescriptor = manager.getByFiletype(file)) != null) {
                        tribbleType = featureDescriptor.getName();
                        logger.info("Dynamically determined type of " + file + " to be " + tribbleType);
                    }
                    if (tribbleType == null) {
                        if (createIntervalBinding) {
                            return new IntervalBinding(value);
                        }
                        if (!file.exists()) {
                            throw new UserException.CouldNotReadInputFile(file, "file does not exist");
                        }
                        if (!file.canRead() || !file.isFile()) {
                            throw new UserException.CouldNotReadInputFile(file, "file could not be read");
                        }
                        throw new UserException.CommandLineException(String.format("No tribble type was provided on the command line and the type of the file could not be determined dynamically. Please add an explicit type tag :NAME listing the correct type from among the supported types:%n%s", manager.userFriendlyListOfAvailableFeatures(parameterType)));
                    }
                }
            }
            Constructor ctor = this.makeRawTypeIfNecessary(type).getConstructor(Class.class, String.class, String.class, String.class, Tags.class);
            if (createIntervalBinding) {
                result = ctor.newInstance(parameterType, name, value, tribbleType, tags);
            } else {
                RodBinding rbind = (RodBinding)ctor.newInstance(parameterType, name, value, tribbleType, tags);
                parsingEngine.addTags(rbind, tags);
                parsingEngine.addRodBinding(rbind);
                result = rbind;
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw new UserException.CommandLineException(String.format("Failed to parse value %s for argument %s.", value, source.field.getName()));
        }
        catch (Exception e) {
            if (e instanceof UserException) {
                throw (UserException)e;
            }
            throw new UserException.CommandLineException(String.format("Failed to parse value %s for argument %s. Message: %s", value, source.field.getName(), e.getMessage()));
        }
    }
}

