/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMFileReader;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.Chunk;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.BlockCompressedFilePointerUtil;

public class BAMIndexMetaData {
    private long noCoordinateRecords = 0L;
    private long firstOffset = -1L;
    private long lastOffset = 0L;
    private int alignedRecords = 0;
    private int unAlignedRecords = 0;

    BAMIndexMetaData() {
        this.newReference();
    }

    BAMIndexMetaData(List<Chunk> chunkList) {
        if (chunkList != null && chunkList.size() != 0 && chunkList.size() != 2) {
            throw new SAMException("Unexpected number of metadata chunks " + chunkList.size());
        }
        boolean firstChunk = true;
        if (chunkList != null) {
            for (Chunk c : chunkList) {
                long start = c.getChunkStart();
                long end = c.getChunkEnd();
                if (firstChunk) {
                    this.firstOffset = start;
                    this.lastOffset = end;
                    firstChunk = false;
                    continue;
                }
                firstChunk = true;
                this.alignedRecords = (int)start;
                this.unAlignedRecords = (int)end;
            }
        }
    }

    void newReference() {
        this.firstOffset = -1L;
        this.lastOffset = 0L;
        this.alignedRecords = 0;
        this.unAlignedRecords = 0;
    }

    void recordMetaData(SAMRecord rec) {
        int alignmentStart = rec.getAlignmentStart();
        if (alignmentStart == 0) {
            this.incrementNoCoordinateRecordCount();
            return;
        }
        Chunk newChunk = ((BAMFileSpan)rec.getFileSource().getFilePointer()).getSingleChunk();
        long start = newChunk.getChunkStart();
        long end = newChunk.getChunkEnd();
        if (rec.getReadUnmappedFlag()) {
            ++this.unAlignedRecords;
        } else {
            ++this.alignedRecords;
        }
        if (BlockCompressedFilePointerUtil.compare(start, this.firstOffset) < 1 || this.firstOffset == -1L) {
            this.firstOffset = start;
        }
        if (BlockCompressedFilePointerUtil.compare(this.lastOffset, end) < 1) {
            this.lastOffset = end;
        }
    }

    void incrementNoCoordinateRecordCount() {
        ++this.noCoordinateRecords;
    }

    void setNoCoordinateRecordCount(long count) {
        this.noCoordinateRecords = count;
    }

    long getNoCoordinateRecordCount() {
        return this.noCoordinateRecords;
    }

    long getFirstOffset() {
        return this.firstOffset;
    }

    long getLastOffset() {
        return this.lastOffset;
    }

    int getUnalignedRecordCount() {
        return this.unAlignedRecords;
    }

    int getAlignedRecordCount() {
        return this.alignedRecords;
    }

    public static void printIndexStats(File inputBamFile) {
        try {
            BAMFileReader bam = new BAMFileReader(inputBamFile, null, false, SAMFileReader.ValidationStringency.SILENT);
            if (!bam.hasIndex()) {
                throw new SAMException("No index for bam file " + inputBamFile);
            }
            BAMIndexMetaData[] data = BAMIndexMetaData.getIndexStats(bam);
            int nRefs = bam.getFileHeader().getSequenceDictionary().size();
            for (int i = 0; i < nRefs; ++i) {
                SAMSequenceRecord seq = bam.getFileHeader().getSequence(i);
                if (seq == null) continue;
                String sequenceName = seq.getSequenceName();
                int sequenceLength = seq.getSequenceLength();
                System.out.print(sequenceName + ' ' + "length=\t" + sequenceLength);
                if (data[i] == null) {
                    System.out.println();
                    continue;
                }
                System.out.println("\tAligned= " + data[i].getAlignedRecordCount() + "\tUnaligned= " + data[i].getUnalignedRecordCount());
            }
            System.out.println("NoCoordinateCount= " + data[0].getNoCoordinateRecordCount());
        }
        catch (IOException e) {
            throw new SAMException("Exception in getting index statistics", e);
        }
    }

    public static BAMIndexMetaData[] getIndexStats(BAMFileReader bam) {
        AbstractBAMFileIndex index = (AbstractBAMFileIndex)bam.getIndex();
        int nRefs = index.getNumberOfReferences();
        BAMIndexMetaData[] result = new BAMIndexMetaData[nRefs];
        for (int i = 0; i < nRefs; ++i) {
            BAMIndexContent content = index.query(i, 0, -1);
            result[i] = content.getMetaData();
        }
        if (result[0] != null) {
            result[0].setNoCoordinateRecordCount(index.getNoCoordinateCount());
        }
        return result;
    }
}

