/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.assembly;

import edu.unc.bioinf.ubu.assembly.Node;
import edu.unc.bioinf.ubu.assembly.ReadPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.sf.samtools.SAMRecord;

public class Contig {
    private UUID id;
    private String descriptor;
    private String sequence = "";
    private List<Node> nodes = new ArrayList<Node>();

    public Contig() {
        this.id = UUID.randomUUID();
    }

    public Contig(Contig orig) {
        this();
        this.sequence = orig.sequence;
        this.nodes.addAll(orig.nodes);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        Contig that = (Contig)object;
        return this.id.equals(that.id);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void append(Node node, String sequence) {
        this.nodes.add(node);
        this.sequence = this.sequence + sequence;
    }

    public void prependSequence(String prependDescriptor, String prefix) {
        this.descriptor = this.descriptor + "_p_" + prependDescriptor;
        this.sequence = prefix + this.sequence;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List<ReadPosition> getFilteredReadPositions() {
        ArrayList<ReadPosition> readPositions = new ArrayList<ReadPosition>();
        int index = 0;
        for (Node node : this.nodes) {
            for (SAMRecord read : node.getStartingReads()) {
                String contigSubstring;
                String readSequence = read.getReadString();
                if (this.sequence.length() < index + readSequence.length() || !(contigSubstring = this.sequence.substring(index, index + readSequence.length())).equals(readSequence)) continue;
                readPositions.add(new ReadPosition(read, index));
            }
            ++index;
        }
        return readPositions;
    }
}

