/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.Coordinate;
import edu.unc.bioinf.ubu.sam.Isoform;
import edu.unc.bioinf.ubu.sam.IsoformIndex;
import edu.unc.bioinf.ubu.sam.IsoformOrderLoader;
import edu.unc.bioinf.ubu.sam.ReadPair;
import edu.unc.bioinf.ubu.sam.ReverseComplementor;
import edu.unc.bioinf.ubu.sam.SamReadPairReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;

public class GenomeToTranscriptomeConverter {
    private IsoformIndex isoformIndex;
    private boolean isPositiveStrandReportingOnly = true;
    private boolean shouldOutputXgTags = false;
    private IsoformOrderLoader isoformOrderLoader;
    private boolean isSingleEnd;
    private ReverseComplementor reverseComplementor = new ReverseComplementor();
    private int totalPairsOutput = 0;

    public GenomeToTranscriptomeConverter(IsoformIndex isoformIndex, IsoformOrderLoader isoformOrderLoader, boolean isSingleEnd) {
        this.isoformIndex = isoformIndex;
        this.isoformOrderLoader = isoformOrderLoader;
        this.isSingleEnd = isSingleEnd;
    }

    private SAMFileHeader buildHeader() {
        SAMFileHeader header = new SAMFileHeader();
        for (Isoform isoform : this.getSortedIsoforms()) {
            SAMSequenceRecord sq = new SAMSequenceRecord(isoform.getIsoformId(), isoform.getLength());
            header.addSequence(sq);
        }
        return header;
    }

    private List<Isoform> getSortedIsoforms() {
        ArrayList<Isoform> isoforms = new ArrayList<Isoform>(this.isoformIndex.getAllIsoforms());
        if (this.isoformOrderLoader != null) {
            Collections.sort(isoforms, new Isoform.IsoformOrderComparator(this.isoformOrderLoader));
            this.isoformOrderLoader.clearCache();
        }
        return isoforms;
    }

    private List<Isoform> getPotentialIsoforms(SAMRecord read1, SAMRecord read2) {
        List<Isoform> isoforms = null;
        isoforms = read1.getReferenceName().equals(read2.getReferenceName()) ? this.getPotentialIsoforms(read1.getReferenceName(), read1.getAlignmentStart(), read2.getAlignmentEnd()) : new ArrayList<Isoform>();
        return isoforms;
    }

    public List<Isoform> getPotentialIsoforms(String chromosome, int genomicStartPos, int genomicEndPos) {
        ArrayList<Isoform> potentialIsoforms = new ArrayList<Isoform>();
        Collection<String> potentials = this.isoformIndex.getPotentialIsoforms(chromosome, genomicStartPos);
        for (String isoformId : potentials) {
            Isoform isoform = this.isoformIndex.getIsoform(isoformId);
            if (!isoform.containsWithinGenomicRange(genomicStartPos, genomicEndPos)) continue;
            potentialIsoforms.add(isoform);
        }
        return potentialIsoforms;
    }

    private List<CigarElement> stripIntrons(Cigar cigar) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>();
        CigarElement prevNonIntronElement = null;
        for (CigarElement element : cigar.getCigarElements()) {
            if (element.getOperator() == CigarOperator.N) continue;
            if (prevNonIntronElement != null && prevNonIntronElement.getOperator() == element.getOperator()) {
                elements.remove(prevNonIntronElement);
                element = new CigarElement(prevNonIntronElement.getLength() + element.getLength(), element.getOperator());
                elements.add(element);
            } else {
                elements.add(element);
            }
            prevNonIntronElement = element;
        }
        return elements;
    }

    private Cigar getPositiveStrandCigar(List<CigarElement> elements) {
        Cigar cigar = new Cigar();
        for (CigarElement element : elements) {
            cigar.add(element);
        }
        return cigar;
    }

    private Cigar getNegativeStrandCigar(List<CigarElement> elements) {
        Collections.reverse(elements);
        Cigar cigar = new Cigar();
        for (CigarElement element : elements) {
            cigar.add(element);
        }
        return cigar;
    }

    private SAMRecord cloneRead(SAMRecord read) {
        try {
            return (SAMRecord)read.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private SAMRecord buildTranscriptRead(SAMRecord read, Isoform isoform, SAMFileHeader header, Cigar positiveCigar, Cigar negativeCigar, int sequenceLength, List<Coordinate> readCoordinates) {
        int readAlignmentStart;
        SAMRecord transcriptRead = this.cloneRead(read);
        transcriptRead.setHeader(header);
        transcriptRead.setReferenceName(isoform.getIsoformId());
        Cigar cigar = null;
        if (this.isPositiveStrandReportingOnly || isoform.isPositiveStrand()) {
            cigar = positiveCigar;
            readAlignmentStart = readCoordinates.get(0).getStart();
        } else {
            sequenceLength *= -1;
            cigar = negativeCigar;
            readAlignmentStart = isoform.getLength() - readCoordinates.get(readCoordinates.size() - 1).getStop() + 1;
            transcriptRead.setReadBases(this.reverseComplementor.reverseComplement(transcriptRead.getReadBases()));
            transcriptRead.setBaseQualities(this.reverseComplementor.reverse(transcriptRead.getBaseQualities()));
            transcriptRead.setReadNegativeStrandFlag(!read.getReadNegativeStrandFlag());
            if (transcriptRead.getReadPairedFlag()) {
                transcriptRead.setMateNegativeStrandFlag(!read.getMateNegativeStrandFlag());
            }
        }
        transcriptRead.setAlignmentStart(readAlignmentStart);
        transcriptRead.setInferredInsertSize(sequenceLength);
        transcriptRead.setCigar(cigar);
        if (this.shouldOutputXgTags) {
            transcriptRead.setAttribute("XG", (Object)(read.getReferenceName() + "." + read.getAlignmentStart()));
        }
        return transcriptRead;
    }

    private void convertAndOutput(SAMRecord read, SAMFileWriter outputSam, SAMFileHeader header) {
        List<Isoform> potentialIsoformMatches = this.getPotentialIsoforms(read.getReferenceName(), read.getAlignmentStart(), read.getAlignmentEnd());
        Cigar positiveCigar = null;
        Cigar negativeCigar = null;
        if (!potentialIsoformMatches.isEmpty()) {
            List<CigarElement> elements = this.stripIntrons(read.getCigar());
            positiveCigar = this.getPositiveStrandCigar(elements);
            negativeCigar = this.getNegativeStrandCigar(elements);
        }
        for (Isoform isoform : potentialIsoformMatches) {
            List<Coordinate> readCoordinates = isoform.match(read);
            if (readCoordinates.isEmpty()) continue;
            int sequenceLength = readCoordinates.get(readCoordinates.size() - 1).getStop() - readCoordinates.get(0).getStart() + 1;
            SAMRecord transcriptRead = this.buildTranscriptRead(read, isoform, header, positiveCigar, negativeCigar, sequenceLength, readCoordinates);
            transcriptRead.setMateAlignmentStart(0);
            transcriptRead.setMateReferenceName("*");
            transcriptRead.setMateUnmappedFlag(true);
            outputSam.addAlignment(transcriptRead);
        }
    }

    private void convertAndOutput(SAMRecord read1, SAMRecord read2, SAMFileWriter outputSam, SAMFileHeader header) {
        List<Isoform> potentialIsoformMatches = this.getPotentialIsoforms(read1, read2);
        Cigar positiveCigar1 = null;
        Cigar negativeCigar1 = null;
        Cigar positiveCigar2 = null;
        Cigar negativeCigar2 = null;
        if (!potentialIsoformMatches.isEmpty()) {
            List<CigarElement> elements1 = this.stripIntrons(read1.getCigar());
            List<CigarElement> elements2 = this.stripIntrons(read2.getCigar());
            positiveCigar1 = this.getPositiveStrandCigar(elements1);
            negativeCigar1 = this.getNegativeStrandCigar(elements1);
            positiveCigar2 = this.getPositiveStrandCigar(elements2);
            negativeCigar2 = this.getNegativeStrandCigar(elements2);
        }
        for (Isoform isoform : potentialIsoformMatches) {
            List<Coordinate> read1Coordinates = isoform.match(read1);
            List<Coordinate> read2Coordinates = isoform.match(read2);
            if (read1Coordinates.isEmpty() || read2Coordinates.isEmpty()) continue;
            int sequenceLength = read2Coordinates.get(read2Coordinates.size() - 1).getStop() - read1Coordinates.get(0).getStart() + 1;
            SAMRecord transcriptRead1 = this.buildTranscriptRead(read1, isoform, header, positiveCigar1, negativeCigar1, sequenceLength, read1Coordinates);
            SAMRecord transcriptRead2 = this.buildTranscriptRead(read2, isoform, header, positiveCigar2, negativeCigar2, -sequenceLength, read2Coordinates);
            transcriptRead1.setMateAlignmentStart(transcriptRead2.getAlignmentStart());
            transcriptRead2.setMateAlignmentStart(transcriptRead1.getAlignmentStart());
            transcriptRead1.setMateReferenceName(isoform.getIsoformId());
            transcriptRead2.setMateReferenceName(isoform.getIsoformId());
            outputSam.addAlignment(transcriptRead1);
            outputSam.addAlignment(transcriptRead2);
            ++this.totalPairsOutput;
        }
    }

    private void convertFileForSingleEnd(String inputFileName, SAMFileWriter outputSam, SAMFileHeader header) {
        System.out.println("Processing single end reads");
        File inputFile = new File(inputFileName);
        SAMFileReader reader = new SAMFileReader(inputFile);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        int cnt = 0;
        for (SAMRecord read : reader) {
            this.convertAndOutput(read, outputSam, header);
            if (cnt++ % 1000000 != 0) continue;
            System.out.println("Processed " + cnt + " reads.");
        }
        reader.close();
    }

    private void convertFileForPairedEnd(String inputFileName, SAMFileWriter outputSam, SAMFileHeader header) {
        System.out.println("Processing paired end reads");
        SamReadPairReader reader = new SamReadPairReader(inputFileName);
        for (ReadPair readPair : reader) {
            this.convertAndOutput(readPair.getRead1(), readPair.getRead2(), outputSam, header);
        }
        reader.close();
    }

    public void convertFile(String inputFileName, String outputFileName) throws Exception {
        System.out.println("Reading file: " + inputFileName);
        System.out.println("Writing to file: " + outputFileName);
        File outputFile = new File(outputFileName);
        System.out.println("Writing header");
        SAMFileHeader header = this.buildHeader();
        SAMFileWriter outputSam = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, true, outputFile);
        if (this.isSingleEnd) {
            this.convertFileForSingleEnd(inputFileName, outputSam, header);
        } else {
            this.convertFileForPairedEnd(inputFileName, outputSam, header);
        }
        outputSam.close();
        System.out.println("Total pairs output: " + this.totalPairsOutput);
        System.out.println("Done.");
    }

    public void setPositiveStrandReportingOnly(boolean isPositiveStrandReportingOnly) {
        this.isPositiveStrandReportingOnly = isPositiveStrandReportingOnly;
    }

    public void setShouldOutputXgTags(boolean shouldOutputXgTags) {
        this.shouldOutputXgTags = shouldOutputXgTags;
    }

    public static void main(String[] args) throws Exception {
    }

    static class Args {
        private String orderFastaFile;
        private String bedFile;
        private String dupeFile;
        private String inputAlignmentFile;
        private String outputAlignmentFile;
        private int readOffset;

        public Args(String[] args) {
            this.bedFile = args[0];
            this.readOffset = Integer.parseInt(args[1]);
            this.inputAlignmentFile = args[2];
            this.outputAlignmentFile = args[3];
            this.orderFastaFile = args[4];
            this.dupeFile = args[5];
            System.out.println(this);
        }

        public String getOrderFastaFile() {
            return this.orderFastaFile;
        }

        public String getBedFile() {
            return this.bedFile;
        }

        public String getDupeFile() {
            return this.dupeFile;
        }

        public String getInputAlignmentFile() {
            return this.inputAlignmentFile;
        }

        public String getOutputAlignmentFile() {
            return this.outputAlignmentFile;
        }

        public int getReadOffset() {
            return this.readOffset;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("bedFile: " + this.bedFile + "\n");
            buf.append("readOffset: " + this.readOffset + "\n");
            buf.append("inputAlignmentFile: " + this.inputAlignmentFile + "\n");
            buf.append("outputAlignmentFile: " + this.outputAlignmentFile + "\n");
            buf.append("orderFastaFile: " + this.orderFastaFile + "\n");
            buf.append("dupeFile: " + this.dupeFile + "\n");
            return buf.toString();
        }
    }
}

