/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IsoformGeneMap {
    public Map<String, String> isoformGeneMap = new HashMap<String, String>();

    public void init(String isoformGeneFile) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(isoformGeneFile));
        String line = reader.readLine();
        while (line != null) {
            String gene;
            String isoform;
            String[] fields = line.split("\t");
            if (fields.length == 2 && !(isoform = fields[1]).equals(gene = fields[0])) {
                this.isoformGeneMap.put(isoform, gene);
            }
            line = reader.readLine();
        }
        reader.close();
        System.out.println("Loaded " + this.isoformGeneMap.keySet().size() + " isoforms");
    }

    public List<String> getSortedGeneList() {
        HashSet<String> geneSet = new HashSet<String>();
        geneSet.addAll(this.isoformGeneMap.values());
        ArrayList<String> genes = new ArrayList<String>();
        genes.addAll(geneSet);
        Collections.sort(genes);
        return genes;
    }

    public String getGene(String isoform) {
        String gene = this.isoformGeneMap.get(isoform);
        if (gene == null) {
            gene = isoform;
        }
        return gene;
    }
}

