/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;

public class ReadBlock {
    private int readStart;
    private int referenceStart;
    private int length;
    private CigarOperator type;

    ReadBlock(int readStart, int referenceStart, int length, CigarOperator type) {
        this.readStart = readStart;
        this.referenceStart = referenceStart;
        this.length = length;
        this.type = type;
    }

    public int getReadStart() {
        return this.readStart;
    }

    public int getReferenceStart() {
        return this.referenceStart;
    }

    public int getReferenceStop() {
        return this.referenceStart + this.length - 1;
    }

    public int getLength() {
        return this.length;
    }

    public int getReferenceLength() {
        int refLength = 0;
        if (this.type != CigarOperator.D) {
            refLength = this.length;
        }
        return refLength;
    }

    public CigarOperator getType() {
        return this.type;
    }

    public ReadBlock getSubBlock(int accumulatedLength, int positionInRead, int maxLength) {
        int positionInBlock = positionInRead + accumulatedLength - this.readStart + 1;
        if (this.type == CigarOperator.N || this.type == CigarOperator.D) {
            return new ReadBlock(accumulatedLength + 1, this.referenceStart + positionInBlock, this.length - positionInBlock, this.type);
        }
        if (this.type == CigarOperator.S) {
            return new ReadBlock(accumulatedLength + 1, this.referenceStart, Math.min(maxLength, this.length - positionInBlock), this.type);
        }
        return new ReadBlock(accumulatedLength + 1, this.referenceStart + positionInBlock, Math.min(maxLength, this.length - positionInBlock), this.type);
    }

    public static String toCigarString(List<ReadBlock> blocks) {
        StringBuffer cigar = new StringBuffer();
        for (ReadBlock block : blocks) {
            cigar.append(block.getLength());
            cigar.append((Object)block.getType());
        }
        return cigar.toString();
    }

    public static List<ReadBlock> getReadBlocks(SAMRecord read) {
        Cigar cigar = read.getCigar();
        if (cigar == null) {
            return Collections.emptyList();
        }
        ArrayList<ReadBlock> readBlocks = new ArrayList<ReadBlock>();
        int readBase = 1;
        int refBase = read.getAlignmentStart();
        block7: for (CigarElement e : cigar.getCigarElements()) {
            readBlocks.add(new ReadBlock(readBase, refBase, e.getLength(), e.getOperator()));
            switch (e.getOperator()) {
                case S: {
                    readBase += e.getLength();
                    continue block7;
                }
                case N: {
                    refBase += e.getLength();
                    continue block7;
                }
                case D: {
                    refBase += e.getLength();
                    continue block7;
                }
                case I: {
                    readBase += e.getLength();
                    continue block7;
                }
                case M: {
                    int length = e.getLength();
                    readBase += length;
                    refBase += length;
                    continue block7;
                }
            }
            throw new IllegalStateException("Case statement didn't deal with cigar op: " + (Object)((Object)e.getOperator()) + " for read: [" + read.getReadName() + "]");
        }
        return Collections.unmodifiableList(readBlocks);
    }
}

