/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.ReadPair;
import edu.unc.bioinf.ubu.sam.SamFilterOptions;
import edu.unc.bioinf.ubu.sam.SamReadPairReader;
import java.io.File;
import java.io.IOException;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class SAMFilter {
    private boolean isPairedEnd = true;
    private boolean shouldStripIndels = false;
    private boolean shouldIncludeIndelsOnly = false;
    private int maxInsertLen = -1;
    private int minMappingQuality = -1;

    public void filter(String input, String output) {
        if (this.isPairedEnd) {
            this.filterPairedEnd(input, output);
        } else {
            this.filterSingleEnd(input, output);
        }
    }

    private void filterPairedEnd(String input, String output) {
        File outputFile = new File(output);
        SamReadPairReader reader = new SamReadPairReader(input);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getHeader(), true, outputFile);
        for (ReadPair pair : reader) {
            if (!this.isReadPairIncluded(pair)) continue;
            writer.addAlignment(pair.getRead1());
            writer.addAlignment(pair.getRead2());
        }
        writer.close();
        reader.close();
    }

    private void filterSingleEnd(String input, String output) {
        File outputFile = new File(output);
        SAMFileReader reader = new SAMFileReader(new File(input));
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, outputFile);
        int cnt = 0;
        for (SAMRecord read : reader) {
            if (this.isReadIncluded(read)) {
                writer.addAlignment(read);
            }
            if (++cnt % 1000000 != 0) continue;
            System.out.println("Processed reads: " + cnt);
        }
        writer.close();
        reader.close();
    }

    boolean isReadPairIncluded(ReadPair pair) {
        if (!this.isPairedEnd) {
            throw new UnsupportedOperationException("Invalid call to isReadPairIncluded for single end filtering.");
        }
        return this.isReadIncluded(pair.getRead1()) && this.isReadIncluded(pair.getRead2());
    }

    boolean isReadIncluded(SAMRecord read) {
        return !this.isFilteredDueToIndelCheck(read) && !this.isMaxInsertLenExceeded(read) && !this.isBelowMinMappingQuality(read);
    }

    private boolean isBelowMinMappingQuality(SAMRecord read) {
        boolean isBelowMin = false;
        if (this.isMinMappingQualitySpecified()) {
            isBelowMin = read.getMappingQuality() < this.minMappingQuality;
        }
        return isBelowMin;
    }

    private boolean isMaxInsertLenExceeded(SAMRecord read) {
        boolean isMaxExceeded = false;
        if (this.isMaxInsertLenSpecified()) {
            isMaxExceeded = Math.abs(read.getInferredInsertSize()) > this.maxInsertLen;
        }
        return isMaxExceeded;
    }

    public void setMaxInsertLen(int len) {
        this.maxInsertLen = len;
    }

    private boolean isMaxInsertLenSpecified() {
        return this.maxInsertLen > 0;
    }

    public void setMinMappingQuality(int min) {
        this.minMappingQuality = min;
    }

    private boolean isMinMappingQualitySpecified() {
        return this.minMappingQuality > 0;
    }

    public void setShouldStripIndels(boolean shouldStripIndels) {
        this.shouldStripIndels = shouldStripIndels;
    }

    public void setShouldIncludeIndelsOnly(boolean shouldIncludeIndelsOnly) {
        this.shouldIncludeIndelsOnly = shouldIncludeIndelsOnly;
    }

    public void setPairedEnd(boolean isPairedEnd) {
        this.isPairedEnd = isPairedEnd;
    }

    private boolean isFilteredDueToIndelCheck(SAMRecord read) {
        if (this.shouldStripIndels) {
            for (CigarElement element : read.getCigar().getCigarElements()) {
                if (element.getOperator() != CigarOperator.D && element.getOperator() != CigarOperator.I) continue;
                return true;
            }
            return false;
        }
        if (this.shouldIncludeIndelsOnly) {
            for (CigarElement element : read.getCigar().getCigarElements()) {
                if (element.getOperator() != CigarOperator.D && element.getOperator() != CigarOperator.I) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void run(String[] args) throws IOException {
        SamFilterOptions options = new SamFilterOptions();
        options.parseOptions(args);
        if (options.isValid()) {
            long s = System.currentTimeMillis();
            SAMFilter filter = new SAMFilter();
            filter.setPairedEnd(options.isPairedEnd());
            filter.setMaxInsertLen(options.getMaxInsertLen());
            filter.setMinMappingQuality(options.getMinMappingQuality());
            filter.setShouldStripIndels(options.shouldStripIndels());
            filter.setShouldIncludeIndelsOnly(options.shouldIncludeIndelsOnly());
            filter.filter(options.getInputFile(), options.getOutputFile());
            long e = System.currentTimeMillis();
            System.out.println("Elapsed: " + (e - s) / 1000L);
        }
    }
}

