/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.util;

import java.io.IOException;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public abstract class Options {
    protected static final String HELP = "help";
    private OptionSet options;

    protected void printHelp() {
        try {
            this.getOptionParser().printHelpOn(System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("IOException encountered when attempting to output help.");
        }
    }

    public void parseOptions(String[] args) {
        try {
            this.options = this.getOptionParser().parse(args);
            if (this.options.has(HELP)) {
                this.printHelp();
            } else {
                this.validate();
            }
        }
        catch (OptionException e) {
            System.err.println(e.getMessage());
            this.printHelp();
        }
    }

    protected OptionSet getOptions() {
        return this.options;
    }

    protected abstract OptionParser getOptionParser();

    protected abstract void validate();
}

