/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.GATKArgumentCollection;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.io.stubs.OutputStreamArgumentTypeDescriptor;
import org.broadinstitute.sting.gatk.io.stubs.SAMFileWriterArgumentTypeDescriptor;
import org.broadinstitute.sting.gatk.io.stubs.VCFWriterArgumentTypeDescriptor;
import org.broadinstitute.sting.gatk.phonehome.GATKRunReport;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.text.ListFileUtils;

public abstract class CommandLineExecutable
extends CommandLineProgram {
    protected GenomeAnalysisEngine engine = new GenomeAnalysisEngine();
    private final Collection<Object> argumentSources = new ArrayList<Object>();
    protected static Logger logger = Logger.getLogger(CommandLineExecutable.class);

    public abstract String getAnalysisName();

    protected abstract GATKArgumentCollection getArgumentCollection();

    @Override
    protected int execute() throws Exception {
        this.engine.setParser(this.parser);
        this.argumentSources.add(this);
        Walker<?, ?> walker = this.engine.getWalkerByName(this.getAnalysisName());
        try {
            this.engine.setArguments(this.getArgumentCollection());
            this.engine.setSAMFileIDs(ListFileUtils.unpackBAMFileList(this.getArgumentCollection().samFiles, this.parser));
            this.engine.setWalker(walker);
            walker.setToolkit(this.engine);
            Collection<ReadFilter> filters = this.engine.createFilters();
            this.engine.setFilters(filters);
            this.loadArgumentsIntoObject(walker);
            this.argumentSources.add(walker);
            Collection<RMDTriplet> rodBindings = ListFileUtils.unpackRODBindings(this.parser.getRodBindings(), this.parser);
            if (this.getArgumentCollection().RODBindings.size() > 0) {
                logger.warn("################################################################################");
                logger.warn("################################################################################");
                logger.warn("Deprecated -B rod binding syntax detected.  This syntax has been eliminated in GATK 1.2.");
                logger.warn("Please use arguments defined by each specific walker instead.");
                for (String oldStyleRodBinding : this.getArgumentCollection().RODBindings) {
                    logger.warn("  -B rod binding with value " + oldStyleRodBinding + " tags: " + this.parser.getTags(oldStyleRodBinding).getPositionalTags());
                }
                logger.warn("################################################################################");
                logger.warn("################################################################################");
                System.exit(1);
            }
            this.engine.setReferenceMetaDataFiles(rodBindings);
            for (ReadFilter filter : filters) {
                this.loadArgumentsIntoObject(filter);
                this.argumentSources.add(filter);
            }
            this.engine.execute();
            this.generateGATKRunReport(walker);
        }
        catch (Exception e) {
            this.generateGATKRunReport(walker, e);
            throw e;
        }
        return 0;
    }

    private void generateGATKRunReport(Walker<?, ?> walker, Exception e) {
        if (this.getArgumentCollection().phoneHomeType != GATKRunReport.PhoneHomeOption.NO_ET) {
            GATKRunReport report = new GATKRunReport(walker, e, this.engine, this.getArgumentCollection().phoneHomeType);
            report.postReport(this.getArgumentCollection().phoneHomeType);
        }
    }

    private void generateGATKRunReport(Walker<?, ?> walker) {
        this.generateGATKRunReport(walker, null);
    }

    @Override
    protected Collection<ArgumentTypeDescriptor> getArgumentTypeDescriptors() {
        return Arrays.asList(new VCFWriterArgumentTypeDescriptor(this.engine, System.out, this.argumentSources), new SAMFileWriterArgumentTypeDescriptor(this.engine, System.out), new OutputStreamArgumentTypeDescriptor(this.engine, System.out));
    }

    @Override
    protected boolean canAddArgumentsDynamically() {
        return true;
    }

    @Override
    protected Class[] getArgumentSources() {
        if (this.getAnalysisName() == null) {
            return new Class[0];
        }
        ArrayList argumentSources = new ArrayList();
        Walker<?, ?> walker = this.engine.getWalkerByName(this.getAnalysisName());
        this.engine.setArguments(this.getArgumentCollection());
        this.engine.setWalker(walker);
        walker.setToolkit(this.engine);
        argumentSources.add(walker.getClass());
        Collection<ReadFilter> filters = this.engine.createFilters();
        for (ReadFilter filter : filters) {
            argumentSources.add(filter.getClass());
        }
        Class[] argumentSourcesAsArray = new Class[argumentSources.size()];
        return argumentSources.toArray(argumentSourcesAsArray);
    }

    @Override
    protected String getArgumentSourceName(Class argumentSource) {
        return this.engine.getWalkerName(argumentSource);
    }
}

