/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedDataState;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.View;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;

public class ManagingReferenceOrderedView
implements ReferenceOrderedView {
    private List<ReferenceOrderedDataState> states = new ArrayList<ReferenceOrderedDataState>();

    public ManagingReferenceOrderedView(LocusShardDataProvider provider) {
        for (ReferenceOrderedDataSource dataSource : provider.getReferenceOrderedData()) {
            this.states.add(new ReferenceOrderedDataState(dataSource, dataSource.seek(provider.getLocus())));
        }
        provider.register(this);
    }

    @Override
    public Collection<Class<? extends View>> getConflictingViews() {
        return Collections.emptyList();
    }

    @Override
    public RefMetaDataTracker getReferenceOrderedDataAtLocus(GenomeLoc loc, ReferenceContext referenceContext) {
        ArrayList<RODRecordList> bindings = this.states.isEmpty() ? Collections.emptyList() : new ArrayList<RODRecordList>(this.states.size());
        for (ReferenceOrderedDataState state : this.states) {
            bindings.add(state.iterator.seekForward(loc));
        }
        return new RefMetaDataTracker(bindings, referenceContext);
    }

    @Override
    public void close() {
        for (ReferenceOrderedDataState state : this.states) {
            state.dataSource.close(state.iterator);
        }
        this.states = null;
    }
}

