/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.List;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import org.broadinstitute.sting.gatk.datasources.reads.BlockInputStream;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;

class SAMReaderPosition {
    private final SAMReaderID reader;
    private final BlockInputStream inputStream;
    private final List<GATKChunk> positions;
    private PeekableIterator<GATKChunk> positionIterator;
    private long nextBlockAddress;

    SAMReaderPosition(SAMReaderID reader, BlockInputStream inputStream, GATKBAMFileSpan fileSpan) {
        this.reader = reader;
        this.inputStream = inputStream;
        this.positions = fileSpan.getGATKChunks();
        this.initialize();
    }

    public SAMReaderID getReader() {
        return this.reader;
    }

    public BlockInputStream getInputStream() {
        return this.inputStream;
    }

    public long getBlockAddress() {
        return this.nextBlockAddress;
    }

    public int getFirstOffsetInBlock() {
        return this.nextBlockAddress == this.positionIterator.peek().getBlockStart() ? this.positionIterator.peek().getBlockOffsetStart() : 0;
    }

    public int getLastOffsetInBlock() {
        return this.nextBlockAddress == this.positionIterator.peek().getBlockEnd() ? this.positionIterator.peek().getBlockOffsetEnd() : 65536;
    }

    public void reset() {
        this.initialize();
    }

    private void initialize() {
        this.positionIterator = new PeekableIterator<GATKChunk>(this.positions.iterator());
        this.nextBlockAddress = this.positionIterator.hasNext() ? this.positionIterator.peek().getBlockStart() : -1L;
    }

    void advancePosition(long filePosition) {
        this.nextBlockAddress = filePosition >> 16;
        while (this.positionIterator.hasNext() && this.isFilePositionPastEndOfChunk(filePosition, this.positionIterator.peek())) {
            this.positionIterator.next();
            if (!this.positionIterator.hasNext() || filePosition >= this.positionIterator.peek().getChunkStart()) continue;
            this.nextBlockAddress = this.positionIterator.peek().getBlockStart();
            break;
        }
        if (!this.positionIterator.hasNext()) {
            this.nextBlockAddress = -1L;
        }
    }

    private boolean isFilePositionPastEndOfChunk(long filePosition, GATKChunk chunk) {
        return filePosition >= chunk.getChunkEnd();
    }
}

