/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.datasources.providers.AllLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.CoveredLocusView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusReferenceView;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.RodLocusView;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class TraverseActiveRegions<M, T>
extends TraversalEngine<M, T, ActiveRegionWalker<M, T>, LocusShardDataProvider> {
    protected static Logger logger = Logger.getLogger(TraversalEngine.class);
    private final Queue<ActiveRegion> workQueue = new LinkedList<ActiveRegion>();
    private final LinkedHashSet<SAMRecord> myReads = new LinkedHashSet();

    @Override
    protected String getTraversalType() {
        return "active regions";
    }

    @Override
    public T traverse(ActiveRegionWalker<M, T> walker, LocusShardDataProvider dataProvider, T sum) {
        logger.debug(String.format("TraverseActiveRegion.traverse: Shard is %s", dataProvider));
        LocusView locusView = this.getLocusView(walker, dataProvider);
        int minStart = Integer.MAX_VALUE;
        LocusReferenceView referenceView = new LocusReferenceView(walker, dataProvider);
        if (locusView.hasNext()) {
            ArrayList<ActiveRegion> isActiveList = new ArrayList<ActiveRegion>();
            ReferenceOrderedView referenceOrderedDataView = null;
            referenceOrderedDataView = WalkerManager.getWalkerDataSource(walker) != DataSource.REFERENCE_ORDERED_DATA ? new ManagingReferenceOrderedView(dataProvider) : (RodLocusView)locusView;
            while (locusView.hasNext()) {
                GATKSAMRecord read;
                AlignmentContext locus = locusView.next();
                GenomeLoc location = locus.getLocation();
                dataProvider.getShard().getReadMetrics().incrementNumIterations();
                if (locus.hasExtendedEventPileup()) {
                    location = this.engine.getGenomeLocParser().setStop(location, location.getStop() + locus.getExtendedEventPileup().getMaxDeletionLength());
                    referenceView.expandBoundsToAccomodateLoc(location);
                }
                ReferenceContext refContext = referenceView.getReferenceContext(location);
                RefMetaDataTracker tracker = referenceOrderedDataView.getReferenceOrderedDataAtLocus(locus.getLocation(), refContext);
                boolean isActive = walker.isActive(tracker, refContext, locus);
                isActiveList.add(new ActiveRegion(location, isActive, this.engine.getGenomeLocParser()));
                for (PileupElement p : locus.getBasePileup()) {
                    read = p.getRead();
                    if (this.myReads.contains(read)) continue;
                    this.myReads.add(read);
                }
                if (!locusView.hasNext()) {
                    for (PileupElement p : locus.getBasePileup()) {
                        read = p.getRead();
                        if (read.getAlignmentStart() >= minStart) continue;
                        minStart = read.getAlignmentStart();
                    }
                }
                this.printProgress(dataProvider.getShard(), locus.getLocation());
            }
            ArrayList<ActiveRegion> activeRegions = this.integrateActiveList(isActiveList);
            logger.debug("Integrated " + isActiveList.size() + " isActive calls into " + activeRegions.size() + " regions.");
            this.workQueue.addAll(activeRegions);
        }
        while (this.workQueue.peek().getLocation().getStop() < minStart) {
            ActiveRegion activeRegion = this.workQueue.remove();
            sum = this.processActiveRegion(activeRegion, this.myReads, this.workQueue, sum, walker);
        }
        return sum;
    }

    public T endTraversal(Walker<M, T> walker, T sum) {
        while (this.workQueue.peek() != null) {
            ActiveRegion activeRegion = this.workQueue.remove();
            sum = this.processActiveRegion(activeRegion, this.myReads, this.workQueue, sum, (ActiveRegionWalker)walker);
        }
        return sum;
    }

    private T processActiveRegion(ActiveRegion activeRegion, LinkedHashSet<SAMRecord> reads, Queue<ActiveRegion> workQueue, T sum, ActiveRegionWalker<M, T> walker) {
        ArrayList<SAMRecord> placedReads = new ArrayList<SAMRecord>();
        for (SAMRecord read : reads) {
            GenomeLoc readLoc = this.engine.getGenomeLocParser().createGenomeLoc(read);
            if (!activeRegion.getLocation().overlapsP(readLoc)) continue;
            long maxOverlap = activeRegion.getLocation().sizeOfOverlap(readLoc);
            ActiveRegion bestRegion = activeRegion;
            for (ActiveRegion otherRegionToTest : workQueue) {
                if (otherRegionToTest.getLocation().sizeOfOverlap(readLoc) < maxOverlap) continue;
                maxOverlap = otherRegionToTest.getLocation().sizeOfOverlap(readLoc);
                bestRegion = otherRegionToTest;
            }
            bestRegion.add((GATKSAMRecord)read, true);
            if (!bestRegion.equals(activeRegion)) {
                activeRegion.add((GATKSAMRecord)read, false);
            }
            for (ActiveRegion otherRegionToTest : workQueue) {
                if (bestRegion.equals(otherRegionToTest) || !otherRegionToTest.getLocation().overlapsP(readLoc)) continue;
                activeRegion.add((GATKSAMRecord)read, false);
            }
            placedReads.add(read);
        }
        reads.removeAll(placedReads);
        logger.debug(">> Map call with " + activeRegion.getReads().size() + " " + (activeRegion.isActive ? "active" : "inactive") + " reads @ " + activeRegion.getLocation() + " with full extent: " + activeRegion.getReferenceLocation());
        M x = walker.map(activeRegion, null);
        return walker.reduce(x, sum);
    }

    private LocusView getLocusView(Walker<M, T> walker, LocusShardDataProvider dataProvider) {
        DataSource dataSource = WalkerManager.getWalkerDataSource(walker);
        if (dataSource == DataSource.READS) {
            return new CoveredLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE) {
            return new AllLocusView(dataProvider);
        }
        if (dataSource == DataSource.REFERENCE_ORDERED_DATA) {
            return new RodLocusView(dataProvider);
        }
        throw new UnsupportedOperationException("Unsupported traversal type: " + (Object)((Object)dataSource));
    }

    private ArrayList<ActiveRegion> integrateActiveList(ArrayList<ActiveRegion> activeList) {
        ActiveRegion prevLocus;
        ArrayList<ActiveRegion> returnList = new ArrayList<ActiveRegion>();
        ActiveRegion startLocus = prevLocus = activeList.remove(0);
        for (ActiveRegion thisLocus : activeList) {
            if (prevLocus.isActive != thisLocus.isActive) {
                returnList.add(new ActiveRegion(this.engine.getGenomeLocParser().createGenomeLoc(startLocus.getLocation().getContig(), startLocus.getLocation().getStart(), prevLocus.getLocation().getStart()), prevLocus.isActive, this.engine.getGenomeLocParser()));
                startLocus = thisLocus;
            }
            prevLocus = thisLocus;
        }
        if (startLocus != prevLocus) {
            returnList.add(new ActiveRegion(this.engine.getGenomeLocParser().createGenomeLoc(startLocus.getLocation().getContig(), startLocus.getLocation().getStart(), prevLocus.getLocation().getStart()), prevLocus.isActive, this.engine.getGenomeLocParser()));
        }
        return returnList;
    }
}

