/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BarcodeData;
import net.sf.picard.illumina.parser.BaseData;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.NoiseData;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.PfData;
import net.sf.picard.illumina.parser.PositionalData;
import net.sf.picard.illumina.parser.QualityData;
import net.sf.picard.illumina.parser.RawIntensityData;
import net.sf.picard.illumina.parser.ReadDescriptor;
import net.sf.picard.illumina.parser.ReadType;

public class IlluminaDataProvider
implements Iterator<ClusterData>,
Iterable<ClusterData> {
    private final File basecallDirectory;
    private final int lane;
    private final IlluminaParser[] parsers;
    private final IlluminaDataType[][] dataTypes;
    private final ReadType[] outputReadTypes;
    private final int numReads;

    IlluminaDataProvider(OutputMapping outputMapping, Map<IlluminaParser, Set<IlluminaDataType>> parsersToDataTypes, File basecallDirectory, int lane) {
        this.basecallDirectory = basecallDirectory;
        this.lane = lane;
        this.numReads = outputMapping.numOutputReads();
        int numParsers = parsersToDataTypes.size();
        if (numParsers == 0) {
            throw new PicardException("There were 0 parsers passed to IlluminaDataProvider!");
        }
        int i = 0;
        this.parsers = new IlluminaParser[numParsers];
        this.dataTypes = new IlluminaDataType[numParsers][];
        for (Map.Entry<IlluminaParser, Set<IlluminaDataType>> pToD : parsersToDataTypes.entrySet()) {
            this.parsers[i] = pToD.getKey();
            Set<IlluminaDataType> dts = pToD.getValue();
            this.dataTypes[i] = new IlluminaDataType[dts.size()];
            dts.toArray(this.dataTypes[i++]);
        }
        this.outputReadTypes = new ReadType[this.numReads];
        i = 0;
        for (ReadDescriptor rd : outputMapping.getOutputDescriptors()) {
            this.outputReadTypes[i++] = rd.type;
        }
    }

    @Override
    public boolean hasNext() {
        boolean more = this.parsers[0].hasNext();
        if (!more) {
            for (int i = 1; i < this.parsers.length; ++i) {
                if (!this.parsers[i].hasNext()) continue;
                throw new PicardException("Unequal length Illumina files in " + this.basecallDirectory + ", lane " + this.lane + ". Failing parser: " + this.parsers.getClass().getName());
            }
        }
        return more;
    }

    @Override
    public ClusterData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ClusterData cluster = new ClusterData(this.outputReadTypes);
        cluster.setLane(this.lane);
        cluster.setTile(this.parsers[0].getTileOfNextCluster());
        for (int i = 0; i < this.parsers.length; ++i) {
            Object ilData = this.parsers[i].next();
            block10: for (IlluminaDataType ilDataType : this.dataTypes[i]) {
                switch (ilDataType) {
                    case Position: {
                        this.addData(cluster, (PositionalData)ilData);
                        continue block10;
                    }
                    case PF: {
                        this.addData(cluster, (PfData)ilData);
                        continue block10;
                    }
                    case Barcodes: {
                        this.addData(cluster, (BarcodeData)ilData);
                        continue block10;
                    }
                    case BaseCalls: {
                        this.addReadData(cluster, this.numReads, (BaseData)ilData);
                        continue block10;
                    }
                    case QualityScores: {
                        this.addReadData(cluster, this.numReads, (QualityData)ilData);
                        continue block10;
                    }
                    case RawIntensities: {
                        this.addReadData(cluster, this.numReads, (RawIntensityData)ilData);
                        continue block10;
                    }
                    case Noise: {
                        this.addReadData(cluster, this.numReads, (NoiseData)ilData);
                        continue block10;
                    }
                    default: {
                        throw new PicardException("Unknown data type " + (Object)((Object)ilDataType) + " requested by IlluminaDataProviderFactory");
                    }
                }
            }
        }
        return cluster;
    }

    private void addData(ClusterData clusterData, PositionalData posData) {
        clusterData.setX(posData.getXCoordinate());
        clusterData.setY(posData.getYCoordinate());
    }

    private void addData(ClusterData clusterData, PfData pfData) {
        clusterData.setPf(pfData.isPf());
    }

    private void addData(ClusterData clusterData, BarcodeData barcodeData) {
        clusterData.setMatchedBarcode(barcodeData.getBarcode());
    }

    private void addReadData(ClusterData clusterData, int numReads, BaseData baseData) {
        byte[][] bases = baseData.getBases();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setBases(bases[i]);
        }
    }

    private void addReadData(ClusterData clusterData, int numReads, QualityData qualityData) {
        byte[][] qualities = qualityData.getQualities();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setQualities(qualities[i]);
        }
    }

    private void addReadData(ClusterData clusterData, int numReads, RawIntensityData rawIntensityData) {
        FourChannelIntensityData[] fcids = rawIntensityData.getRawIntensities();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setRawIntensities(fcids[i]);
        }
    }

    private void addReadData(ClusterData clusterData, int numReads, NoiseData noiseData) {
        FourChannelIntensityData[] fcids = noiseData.getNoise();
        for (int i = 0; i < numReads; ++i) {
            clusterData.getRead(i).setNoise(fcids[i]);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void seekToTile(int oneBasedTileNumber) {
        for (IlluminaParser parser : this.parsers) {
            parser.seekToTile(oneBasedTileNumber);
        }
    }

    @Override
    public Iterator<ClusterData> iterator() {
        return this;
    }
}

