/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.ClassicGlobal;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.selector.ContextSelector;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.JNDIUtil;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextJNDISelector
implements ContextSelector {
    private final Map<String, LoggerContext> contextMap = Collections.synchronizedMap(new HashMap());
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();

    public ContextJNDISelector(LoggerContext context) {
        this.defaultContext = context;
    }

    @Override
    public LoggerContext getLoggerContext() {
        String contextName = null;
        Context ctx = null;
        LoggerContext lc = threadLocal.get();
        if (lc != null) {
            return lc;
        }
        try {
            ctx = JNDIUtil.getInitialContext();
            contextName = JNDIUtil.lookup(ctx, ClassicGlobal.JNDI_CONTEXT_NAME);
        }
        catch (NamingException ne) {
            // empty catch block
        }
        if (contextName == null) {
            return this.defaultContext;
        }
        LoggerContext loggerContext = this.contextMap.get(contextName);
        if (loggerContext == null) {
            loggerContext = new LoggerContext();
            loggerContext.setName(contextName);
            this.contextMap.put(contextName, loggerContext);
            String configFilePath = JNDIUtil.lookup(ctx, ClassicGlobal.JNDI_CONFIGURATION_RESOURCE);
            if (configFilePath != null) {
                this.configureLoggerContextByResource(loggerContext, configFilePath);
            } else {
                try {
                    ContextInitializer.autoConfig(loggerContext);
                }
                catch (JoranException je) {
                    StatusPrinter.print(loggerContext);
                }
            }
        }
        return loggerContext;
    }

    @Override
    public LoggerContext getDefaultLoggerContext() {
        return this.defaultContext;
    }

    @Override
    public LoggerContext detachLoggerContext(String loggerContextName) {
        return this.contextMap.remove(loggerContextName);
    }

    private void configureLoggerContextByResource(LoggerContext context, String configFilePath) {
        URL url = Loader.getResourceByTCL(configFilePath);
        if (url != null) {
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                context.shutdownAndReset();
                configurator.setContext(context);
                configurator.doConfigure(url);
            }
            catch (JoranException e) {
                StatusPrinter.print(context);
            }
        } else {
            Logger logger = this.defaultContext.getLogger("root");
            logger.warn("The provided URL for context" + context.getName() + " does not lead to a valid file");
        }
    }

    @Override
    public List<String> getContextNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.contextMap.keySet());
        return list;
    }

    @Override
    public LoggerContext getLoggerContext(String name) {
        return this.contextMap.get(name);
    }

    public int getCount() {
        return this.contextMap.size();
    }

    public void setLocalContext(LoggerContext context) {
        threadLocal.set(context);
    }

    public void removeLocalContext() {
        threadLocal.remove();
    }
}

