/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.ArrayList;
import org.apache.commons.jexl2.Interpreter;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlInfo;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.StringParser;

public final class UnifiedJEXL {
    private final JexlEngine jexl;
    private final JexlEngine.SoftCache<String, Expression> cache;
    private static final int CACHE_SIZE = 256;

    public UnifiedJEXL(JexlEngine aJexl) {
        this(aJexl, 256);
    }

    public UnifiedJEXL(JexlEngine aJexl, int cacheSize) {
        this.jexl = aJexl;
        JexlEngine jexlEngine = aJexl;
        jexlEngine.getClass();
        this.cache = jexlEngine.new JexlEngine.SoftCache(cacheSize);
    }

    public JexlEngine getEngine() {
        return this.jexl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression parse(String expression) {
        Expression stmt;
        block13: {
            Exception xuel = null;
            stmt = null;
            try {
                if (this.cache == null) {
                    stmt = this.parseExpression(expression);
                    break block13;
                }
                JexlEngine.SoftCache<String, Expression> softCache = this.cache;
                synchronized (softCache) {
                    stmt = this.cache.get(expression);
                    if (stmt == null) {
                        stmt = this.parseExpression(expression);
                        this.cache.put(expression, stmt);
                    }
                }
            }
            catch (JexlException xjexl) {
                xuel = new Exception("failed to parse '" + expression + "'", xjexl);
                return xuel;
            }
            catch (Exception xany) {
                xuel = xany;
                return xuel;
            }
            finally {
                if (xuel == null) break block13;
                if (this.jexl.isSilent()) {
                    this.jexl.logger.warn(xuel.getMessage(), xuel.getCause());
                    return null;
                }
                throw xuel;
            }
        }
        return stmt;
    }

    Expression prepare(JexlContext context, Expression expr) {
        try {
            Interpreter interpreter = this.jexl.createInterpreter(context);
            interpreter.setSilent(false);
            return expr.prepare(interpreter);
        }
        catch (JexlException xjexl) {
            Exception xuel = this.createException("prepare", expr, xjexl);
            if (this.jexl.isSilent()) {
                this.jexl.logger.warn(xuel.getMessage(), xuel.getCause());
                return null;
            }
            throw xuel;
        }
    }

    Object evaluate(JexlContext context, Expression expr) {
        try {
            Interpreter interpreter = this.jexl.createInterpreter(context);
            interpreter.setSilent(false);
            return expr.evaluate(interpreter);
        }
        catch (JexlException xjexl) {
            Exception xuel = this.createException("evaluate", expr, xjexl);
            if (this.jexl.isSilent()) {
                this.jexl.logger.warn(xuel.getMessage(), xuel.getCause());
                return null;
            }
            throw xuel;
        }
    }

    private JexlNode toNode(CharSequence expression) {
        return this.jexl.parse(expression, null);
    }

    private JexlNode toNode(CharSequence expression, JexlInfo info) {
        return this.jexl.parse(expression, info);
    }

    private Exception createException(String action, Expression expr, java.lang.Exception xany) {
        String causeMsg;
        StringBuilder strb = new StringBuilder("failed to ");
        strb.append(action);
        strb.append(" '");
        strb.append(expr.toString());
        strb.append("'");
        Throwable cause = xany.getCause();
        if (cause != null && (causeMsg = cause.getMessage()) != null) {
            strb.append(", ");
            strb.append(causeMsg);
        }
        return new Exception(strb.toString(), xany);
    }

    private Expression parseExpression(String expr) {
        int size = expr.length();
        ExpressionBuilder builder = new ExpressionBuilder(0);
        StringBuilder strb = new StringBuilder(size);
        ParseState state = ParseState.CONST;
        int inner = 0;
        boolean nested = false;
        int inested = -1;
        block8: for (int i = 0; i < size; ++i) {
            char c = expr.charAt(i);
            switch (state) {
                default: {
                    throw new UnsupportedOperationException("unexpected expression type");
                }
                case CONST: {
                    if (c == '$') {
                        state = ParseState.IMMEDIATE0;
                        continue block8;
                    }
                    if (c == '#') {
                        inested = i;
                        state = ParseState.DEFERRED0;
                        continue block8;
                    }
                    if (c == '\\') {
                        state = ParseState.ESCAPE;
                        continue block8;
                    }
                    strb.append(c);
                    continue block8;
                }
                case IMMEDIATE0: {
                    ConstantExpression cexpr;
                    if (c == '{') {
                        state = ParseState.IMMEDIATE1;
                        if (strb.length() <= 0) continue block8;
                        cexpr = new ConstantExpression(strb.toString(), null);
                        builder.add(cexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        continue block8;
                    }
                    strb.append('$');
                    strb.append(c);
                    state = ParseState.CONST;
                    continue block8;
                }
                case DEFERRED0: {
                    ConstantExpression cexpr;
                    if (c == '{') {
                        state = ParseState.DEFERRED1;
                        if (strb.length() <= 0) continue block8;
                        cexpr = new ConstantExpression(strb.toString(), null);
                        builder.add(cexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        continue block8;
                    }
                    strb.append('#');
                    strb.append(c);
                    state = ParseState.CONST;
                    continue block8;
                }
                case IMMEDIATE1: {
                    if (c == '}') {
                        ImmediateExpression iexpr = new ImmediateExpression(strb.toString(), this.toNode(strb), null);
                        builder.add(iexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        state = ParseState.CONST;
                        continue block8;
                    }
                    strb.append(c);
                    continue block8;
                }
                case DEFERRED1: {
                    if (c == '\"' || c == '\'') {
                        strb.append(c);
                        i = StringParser.readString(strb, expr, i + 1, c);
                        continue block8;
                    }
                    if (c == '{') {
                        if (expr.charAt(i - 1) != '$') continue block8;
                        ++inner;
                        strb.deleteCharAt(strb.length() - 1);
                        nested = true;
                        continue block8;
                    }
                    if (c == '}') {
                        if (inner > 0) {
                            --inner;
                            continue block8;
                        }
                        DeferredExpression dexpr = null;
                        dexpr = nested ? new NestedExpression(expr.substring(inested, i + 1), this.toNode(strb), null) : new DeferredExpression(strb.toString(), this.toNode(strb), null);
                        builder.add(dexpr);
                        strb.delete(0, Integer.MAX_VALUE);
                        nested = false;
                        state = ParseState.CONST;
                        continue block8;
                    }
                    strb.append(c);
                    continue block8;
                }
                case ESCAPE: {
                    if (c == '#') {
                        strb.append('#');
                    } else if (c == '$') {
                        strb.append('$');
                    } else {
                        strb.append('\\');
                        strb.append(c);
                    }
                    state = ParseState.CONST;
                }
            }
        }
        if (state != ParseState.CONST) {
            throw new Exception("malformed expression: " + expr, null);
        }
        if (strb.length() > 0) {
            ConstantExpression cexpr = new ConstantExpression(strb.toString(), null);
            builder.add(cexpr);
        }
        return builder.build(this, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseState {
        CONST,
        IMMEDIATE0,
        DEFERRED0,
        IMMEDIATE1,
        DEFERRED1,
        ESCAPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeExpression
    extends Expression {
        private final int meta;
        private final Expression[] exprs;

        CompositeExpression(int[] counters, ArrayList<Expression> list, Expression src) {
            super(src);
            this.exprs = list.toArray(new Expression[list.size()]);
            this.meta = (counters[ExpressionType.DEFERRED.index] > 0 ? 2 : 0) | (counters[ExpressionType.IMMEDIATE.index] > 0 ? 1 : 0);
        }

        @Override
        ExpressionType getType() {
            return ExpressionType.COMPOSITE;
        }

        @Override
        public boolean isImmediate() {
            return (this.meta & 2) == 0;
        }

        @Override
        void asString(StringBuilder strb) {
            for (Expression e : this.exprs) {
                e.asString(strb);
            }
        }

        @Override
        public Expression prepare(JexlContext context) {
            return UnifiedJEXL.this.prepare(context, this);
        }

        @Override
        Expression prepare(Interpreter interpreter) {
            if (this.source != this) {
                return this;
            }
            boolean evalImmediate = this.meta == 3;
            int size = this.exprs.length;
            ExpressionBuilder builder = new ExpressionBuilder(size);
            boolean eq = true;
            for (int e = 0; e < size; ++e) {
                Expression expr = this.exprs[e];
                Expression prepared = expr.prepare(interpreter);
                if (evalImmediate && prepared instanceof ImmediateExpression) {
                    Object value = prepared.evaluate(interpreter);
                    Expression expression = prepared = value == null ? null : new ConstantExpression(value, prepared);
                }
                if (prepared != null) {
                    builder.add(prepared);
                }
                eq &= expr == prepared;
            }
            CompositeExpression ready = eq ? this : builder.build(UnifiedJEXL.this, this);
            return ready;
        }

        @Override
        public Object evaluate(JexlContext context) {
            return UnifiedJEXL.this.evaluate(context, this);
        }

        @Override
        Object evaluate(Interpreter interpreter) {
            int size = this.exprs.length;
            Object value = null;
            StringBuilder strb = new StringBuilder();
            for (int e = 0; e < size; ++e) {
                value = this.exprs[e].evaluate(interpreter);
                if (value == null) continue;
                strb.append(value.toString());
            }
            value = strb.toString();
            return value;
        }
    }

    private class NestedExpression
    extends DeferredExpression {
        NestedExpression(CharSequence expr, JexlNode node, Expression source) {
            super(expr, node, source);
            if (this.source != this) {
                throw new IllegalArgumentException("Nested expression can not have a source");
            }
        }

        ExpressionType getType() {
            return ExpressionType.NESTED;
        }

        public String toString() {
            return ((Object)this.expr).toString();
        }

        public Expression prepare(JexlContext context) {
            return UnifiedJEXL.this.prepare(context, this);
        }

        public Expression prepare(Interpreter interpreter) {
            String value = interpreter.interpret(this.node).toString();
            JexlNode dnode = UnifiedJEXL.this.toNode(value, UnifiedJEXL.this.jexl.isDebug() ? this.node.getInfo() : null);
            return new DeferredExpression(value, dnode, this);
        }

        public Object evaluate(Interpreter interpreter) {
            return this.prepare(interpreter).evaluate(interpreter);
        }
    }

    private class DeferredExpression
    extends JexlBasedExpression {
        DeferredExpression(CharSequence expr, JexlNode node, Expression source) {
            super(expr, node, source);
        }

        ExpressionType getType() {
            return ExpressionType.DEFERRED;
        }

        public boolean isImmediate() {
            return false;
        }
    }

    private class ImmediateExpression
    extends JexlBasedExpression {
        ImmediateExpression(CharSequence expr, JexlNode node, Expression source) {
            super(expr, node, source);
        }

        ExpressionType getType() {
            return ExpressionType.IMMEDIATE;
        }

        public boolean isImmediate() {
            return true;
        }
    }

    private abstract class JexlBasedExpression
    extends Expression {
        protected final CharSequence expr;
        protected final JexlNode node;

        protected JexlBasedExpression(CharSequence theExpr, JexlNode theNode, Expression theSource) {
            super(theSource);
            this.expr = theExpr;
            this.node = theNode;
        }

        public String toString() {
            StringBuilder strb = new StringBuilder(this.expr.length() + 3);
            if (this.source != this) {
                strb.append(this.source.toString());
                strb.append(" /*= ");
            }
            strb.append(this.isImmediate() ? (char)'$' : '#');
            strb.append("{");
            strb.append(this.expr);
            strb.append("}");
            if (this.source != this) {
                strb.append(" */");
            }
            return strb.toString();
        }

        public void asString(StringBuilder strb) {
            strb.append(this.isImmediate() ? (char)'$' : '#');
            strb.append("{");
            strb.append(this.expr);
            strb.append("}");
        }

        public Expression prepare(JexlContext context) {
            return this;
        }

        Expression prepare(Interpreter interpreter) {
            return this;
        }

        public Object evaluate(JexlContext context) {
            return UnifiedJEXL.this.evaluate(context, this);
        }

        Object evaluate(Interpreter interpreter) {
            return interpreter.interpret(this.node);
        }
    }

    private class ConstantExpression
    extends Expression {
        private final Object value;

        ConstantExpression(Object val, Expression source) {
            super(source);
            if (val == null) {
                throw new NullPointerException("constant can not be null");
            }
            if (val instanceof String) {
                val = StringParser.buildString((String)val, false);
            }
            this.value = val;
        }

        public String asString() {
            StringBuilder strb = new StringBuilder();
            strb.append('\"');
            this.asString(strb);
            strb.append('\"');
            return strb.toString();
        }

        ExpressionType getType() {
            return ExpressionType.CONSTANT;
        }

        void asString(StringBuilder strb) {
            String str = this.value.toString();
            if (this.value instanceof String || this.value instanceof CharSequence) {
                int size = str.length();
                for (int i = 0; i < size; ++i) {
                    char c = str.charAt(i);
                    if (c == '\"' || c == '\\') {
                        strb.append('\\');
                    }
                    strb.append(c);
                }
            } else {
                strb.append(str);
            }
        }

        public Expression prepare(JexlContext context) {
            return this;
        }

        Expression prepare(Interpreter interpreter) {
            return this;
        }

        public Object evaluate(JexlContext context) {
            return this.value;
        }

        Object evaluate(Interpreter interpreter) {
            return this.value;
        }
    }

    public abstract class Expression {
        protected final Expression source;

        Expression(Expression src) {
            this.source = src != null ? src : this;
        }

        public String toString() {
            StringBuilder strb = new StringBuilder();
            if (this.source != this) {
                strb.append(this.source.toString());
                strb.append(" /*= ");
            }
            this.asString(strb);
            if (this.source != this) {
                strb.append(" */");
            }
            return strb.toString();
        }

        public String asString() {
            StringBuilder strb = new StringBuilder();
            this.asString(strb);
            return strb.toString();
        }

        abstract void asString(StringBuilder var1);

        public abstract Expression prepare(JexlContext var1);

        public abstract Object evaluate(JexlContext var1);

        public boolean isImmediate() {
            return true;
        }

        public final boolean isDeferred() {
            return !this.isImmediate();
        }

        public final Expression getSource() {
            return this.source;
        }

        abstract ExpressionType getType();

        abstract Expression prepare(Interpreter var1);

        abstract Object evaluate(Interpreter var1);
    }

    public static class Exception
    extends RuntimeException {
        private static final long serialVersionUID = -8201402995815975726L;

        public Exception(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class ExpressionBuilder {
        private final int[] counts = new int[]{0, 0, 0};
        private final ArrayList<Expression> expressions;

        ExpressionBuilder(int size) {
            this.expressions = new ArrayList(size <= 0 ? 3 : size);
        }

        void add(Expression expr) {
            int n = expr.getType().index;
            this.counts[n] = this.counts[n] + 1;
            this.expressions.add(expr);
        }

        Expression build(UnifiedJEXL el, Expression source) {
            int sum = 0;
            for (int count : this.counts) {
                sum += count;
            }
            if (this.expressions.size() != sum) {
                StringBuilder error = new StringBuilder("parsing algorithm error, exprs: ");
                error.append(this.expressions.size());
                error.append(", constant:");
                error.append(this.counts[ExpressionType.CONSTANT.index]);
                error.append(", immediate:");
                error.append(this.counts[ExpressionType.IMMEDIATE.index]);
                error.append(", deferred:");
                error.append(this.counts[ExpressionType.DEFERRED.index]);
                throw new IllegalStateException(error.toString());
            }
            if (this.expressions.size() == 1) {
                return this.expressions.get(0);
            }
            UnifiedJEXL unifiedJEXL = el;
            unifiedJEXL.getClass();
            return unifiedJEXL.new CompositeExpression(this.counts, this.expressions, source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExpressionType {
        CONSTANT(0),
        IMMEDIATE(1),
        DEFERRED(2),
        NESTED(2),
        COMPOSITE(-1);

        private final int index;

        private ExpressionType(int idx) {
            this.index = idx;
        }
    }
}

