/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment;

import java.util.Iterator;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.BWAConfiguration;
import org.broadinstitute.sting.alignment.bwa.BWTFiles;
import org.broadinstitute.sting.alignment.bwa.c.BWACAligner;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class AlignmentValidationWalker
extends ReadWalker<Integer, Integer> {
    @Argument(fullName="BWTPrefix", shortName="BWT", doc="Index files generated by bwa index -d bwtsw", required=false)
    private String prefix = null;
    private BWACAligner aligner = null;

    @Override
    public void initialize() {
        if (this.prefix == null) {
            this.prefix = this.getToolkit().getArguments().referenceFile.getAbsolutePath();
        }
        BWTFiles bwtFiles = new BWTFiles(this.prefix);
        BWAConfiguration configuration = new BWAConfiguration();
        this.aligner = new BWACAligner(bwtFiles, configuration);
    }

    @Override
    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        byte[] bases = read.getReadBases();
        if (read.getReadNegativeStrandFlag()) {
            bases = BaseUtils.simpleReverseComplement(bases);
        }
        boolean matches = true;
        Iterable<Alignment[]> alignments = this.aligner.getAllAlignments(bases);
        Iterator<Alignment[]> alignmentIterator = alignments.iterator();
        if (!alignmentIterator.hasNext()) {
            matches = read.getReadUnmappedFlag();
        } else {
            Alignment[] alignmentsOfBestQuality;
            for (Alignment alignment : alignmentsOfBestQuality = alignmentIterator.next()) {
                matches = alignment.getContigIndex() == read.getReferenceIndex().intValue();
                matches &= alignment.getAlignmentStart() == (long)read.getAlignmentStart();
                matches &= alignment.isNegativeStrand() == read.getReadNegativeStrandFlag();
                matches &= alignment.getCigar().equals(read.getCigar());
                if (matches &= alignment.getMappingQuality() == read.getMappingQuality()) break;
            }
        }
        if (!matches) {
            logger.error("Found mismatch!");
            logger.error(String.format("Read %s:", read.getReadName()));
            logger.error(String.format("    Contig index: %d", read.getReferenceIndex()));
            logger.error(String.format("    Alignment start: %d", read.getAlignmentStart()));
            logger.error(String.format("    Negative strand: %b", read.getReadNegativeStrandFlag()));
            logger.error(String.format("    Cigar: %s%n", read.getCigarString()));
            logger.error(String.format("    Mapping quality: %s%n", read.getMappingQuality()));
            for (Alignment[] alignmentsByScore : alignments) {
                for (int i = 0; i < alignmentsByScore.length; ++i) {
                    logger.error(String.format("Alignment %d:", i));
                    logger.error(String.format("    Contig index: %d", alignmentsByScore[i].getContigIndex()));
                    logger.error(String.format("    Alignment start: %d", alignmentsByScore[i].getAlignmentStart()));
                    logger.error(String.format("    Negative strand: %b", alignmentsByScore[i].isNegativeStrand()));
                    logger.error(String.format("    Cigar: %s", alignmentsByScore[i].getCigarString()));
                    logger.error(String.format("    Mapping quality: %s%n", alignmentsByScore[i].getMappingQuality()));
                }
            }
            throw new ReviewedStingException(String.format("Read %s mismatches!", read.getReadName()));
        }
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.aligner.close();
        super.onTraversalDone(result);
    }
}

