/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;

public class AMBWriter {
    private static final int NUM_HOLES = 0;
    private final PrintStream out;

    public AMBWriter(File file) throws IOException {
        this.out = new PrintStream(file);
    }

    public AMBWriter(OutputStream stream) {
        this.out = new PrintStream(stream);
    }

    public void writeEmpty(SAMSequenceDictionary dictionary) {
        long genomeLength = 0L;
        for (SAMSequenceRecord sequence : dictionary.getSequences()) {
            genomeLength += (long)sequence.getSequenceLength();
        }
        int sequences = dictionary.getSequences().size();
        this.out.printf("%d %d %d%n", genomeLength, sequences, 0);
    }

    public void close() {
        this.out.close();
    }
}

