/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.packing;

import java.io.File;
import java.io.IOException;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;

public class CreatePACFromReference {
    public static void main(String[] argv) throws IOException {
        if (argv.length != 3) {
            System.out.println("USAGE: CreatePACFromReference <input>.fasta <output pac> <output rpac>");
            return;
        }
        String inputFileName = argv[0];
        File inputFile = new File(inputFileName);
        ReferenceSequenceFile reference = ReferenceSequenceFileFactory.getReferenceSequenceFile(inputFile);
        ReferenceSequence sequence = reference.nextSequence();
        PackUtils.writeReferenceSequence(new File(argv[1]), sequence.getBases());
        PackUtils.reverse(sequence.getBases());
        PackUtils.writeReferenceSequence(new File(argv[2]), sequence.getBases());
    }
}

