/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.packing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;

public class UnsignedIntPackedOutputStream {
    private final OutputStream targetOutputStream;
    private final ByteBuffer buffer;

    public UnsignedIntPackedOutputStream(File outputFile, ByteOrder byteOrder) throws IOException {
        this(new FileOutputStream(outputFile), byteOrder);
    }

    public UnsignedIntPackedOutputStream(OutputStream outputStream, ByteOrder byteOrder) {
        this.targetOutputStream = outputStream;
        this.buffer = ByteBuffer.allocate(PackUtils.bitsInType(Integer.class) / 8).order(byteOrder);
    }

    public void write(long datum) throws IOException {
        this.buffer.rewind();
        this.buffer.putInt((int)datum);
        this.targetOutputStream.write(this.buffer.array());
    }

    public void write(long[] data) throws IOException {
        for (long datum : data) {
            this.write(datum);
        }
    }

    public void write(long[] data, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            this.write(data[i]);
        }
    }

    public void flush() throws IOException {
        this.targetOutputStream.flush();
    }

    public void close() throws IOException {
        this.targetOutputStream.close();
    }
}

