/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;

public class ReadFormattingIterator
implements StingSAMIterator {
    protected static final Logger logger = Logger.getLogger(ReadFormattingIterator.class);
    private StingSAMIterator wrappedIterator;
    private final boolean useOriginalBaseQualities;
    private final byte defaultBaseQualities;

    public ReadFormattingIterator(StingSAMIterator wrappedIterator, boolean useOriginalBaseQualities, byte defaultBaseQualities) {
        this.wrappedIterator = wrappedIterator;
        this.useOriginalBaseQualities = useOriginalBaseQualities;
        this.defaultBaseQualities = defaultBaseQualities;
    }

    public StingSAMIterator iterator() {
        return this;
    }

    @Override
    public void close() {
        this.wrappedIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.wrappedIterator.hasNext();
    }

    @Override
    public SAMRecord next() {
        byte[] originalQuals;
        SAMRecord rec = (SAMRecord)this.wrappedIterator.next();
        if (this.defaultBaseQualities >= 0) {
            byte[] reads = rec.getReadBases();
            byte[] quals = rec.getBaseQualities();
            if (quals == null || quals.length < reads.length) {
                byte[] new_quals = new byte[reads.length];
                for (int i = 0; i < reads.length; ++i) {
                    new_quals[i] = this.defaultBaseQualities;
                }
                rec.setBaseQualities(new_quals);
            }
        }
        if (this.useOriginalBaseQualities && (originalQuals = rec.getOriginalBaseQualities()) != null) {
            rec.setBaseQualities(originalQuals);
        }
        return rec;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a ReadWrappingIterator");
    }
}

