/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.report.GATKReportVersion;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;

public class GATKReport {
    public static final String GATKREPORT_HEADER_PREFIX = "##:GATKReport.v";
    private TreeMap<String, GATKReportTable> tables = new TreeMap();

    public GATKReport() {
    }

    public GATKReport(String filename) {
        this(new File(filename));
    }

    public GATKReport(File file) {
        this.loadReport(file);
    }

    private void loadReport(File file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            GATKReportTable table = null;
            String[] header = null;
            int id = 0;
            GATKReportVersion version = null;
            List<Integer> columnStarts = null;
            while ((line = reader.readLine()) != null) {
                String[] splitLine;
                if (line.startsWith(GATKREPORT_HEADER_PREFIX)) {
                    version = GATKReportVersion.fromHeader(line);
                    line = line.replaceFirst("##:GATKReport." + version.versionString + " ", "");
                    String[] pieces = line.split(" : ");
                    String tableName = pieces[0];
                    String tableDesc = pieces[1];
                    this.addTable(tableName, tableDesc);
                    table = this.getTable(tableName);
                    table.setVersion(version);
                    header = null;
                    columnStarts = null;
                    continue;
                }
                if (line.trim().isEmpty() || table == null) continue;
                switch (version) {
                    case V0_1: {
                        splitLine = TextFormattingUtils.splitWhiteSpace(line);
                        break;
                    }
                    case V0_2: {
                        if (header == null) {
                            columnStarts = TextFormattingUtils.getWordStarts(line);
                        }
                        splitLine = TextFormattingUtils.splitFixedWidth(line, columnStarts);
                        break;
                    }
                    default: {
                        throw new ReviewedStingException("GATK report version parsing not implemented for: " + line);
                    }
                }
                if (header == null) {
                    header = splitLine;
                    table.addPrimaryKey("id", false);
                    for (String columnName : header) {
                        table.addColumn(columnName, "");
                    }
                    id = 0;
                    continue;
                }
                for (int columnIndex = 0; columnIndex < header.length; ++columnIndex) {
                    table.set(id, header[columnIndex], splitLine[columnIndex]);
                }
                ++id;
            }
        }
        catch (FileNotFoundException e) {
            throw new StingException("Cannot read GATKReport: " + e);
        }
        catch (IOException e) {
            throw new StingException("Cannot read GATKReport: " + e);
        }
    }

    public void addTable(String tableName, String tableDescription) {
        this.addTable(tableName, tableDescription, true);
    }

    public void addTable(String tableName, String tableDescription, boolean sortByPrimaryKey) {
        GATKReportTable table = new GATKReportTable(tableName, tableDescription, sortByPrimaryKey);
        this.tables.put(tableName, table);
    }

    public boolean hasTable(String tableName) {
        return this.tables.containsKey(tableName);
    }

    public GATKReportTable getTable(String tableName) {
        GATKReportTable table = this.tables.get(tableName);
        if (table == null) {
            throw new ReviewedStingException("Table is not in GATKReport: " + tableName);
        }
        return table;
    }

    public void print(PrintStream out) {
        for (GATKReportTable table : this.tables.values()) {
            if (table.getNumRows() <= 0) continue;
            table.write(out);
        }
    }

    public Collection<GATKReportTable> getTables() {
        return this.tables.values();
    }
}

