/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class BaseCounts
extends InfoFieldAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        int[] counts = new int[4];
        for (Map.Entry<String, AlignmentContext> sample : stratifiedContexts.entrySet()) {
            if (!sample.getValue().hasBasePileup()) continue;
            for (byte base : sample.getValue().getBasePileup().getBases()) {
                int index = BaseUtils.simpleBaseToBaseIndex(base);
                if (index == -1) continue;
                int n = index;
                counts[n] = counts[n] + 1;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), counts);
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("BaseCounts");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("BaseCounts", 4, VCFHeaderLineType.Integer, "Counts of each base"));
    }
}

