/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.Arrays;
import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.RequiredCovariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ReadGroupCovariate
implements RequiredCovariate {
    private final HashMap<String, Short> readGroupLookupTable = new HashMap();
    private final HashMap<Short, String> readGroupReverseLookupTable = new HashMap();
    private short nextId = 0;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
    }

    @Override
    public CovariateValues getValues(GATKSAMRecord read) {
        short shortId;
        int l = read.getReadLength();
        String readGroupId = read.getReadGroup().getReadGroupId();
        if (this.readGroupLookupTable.containsKey(readGroupId)) {
            shortId = this.readGroupLookupTable.get(readGroupId);
        } else {
            shortId = this.nextId;
            this.readGroupLookupTable.put(readGroupId, this.nextId);
            this.readGroupReverseLookupTable.put(this.nextId, readGroupId);
            this.nextId = (short)(this.nextId + 1);
        }
        Object[] readGroups = new Short[l];
        Arrays.fill(readGroups, (Object)shortId);
        return new CovariateValues(readGroups, readGroups, readGroups);
    }

    @Override
    public final Object getValue(String str) {
        return str;
    }

    public final String decodeReadGroup(short id) {
        return this.readGroupReverseLookupTable.get(id);
    }
}

