/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import net.sf.samtools.FileTruncatedException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffNode;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffableReader;

public class BAMDiffableReader
implements DiffableReader {
    @Override
    public String getName() {
        return "BAM";
    }

    @Override
    public DiffElement readFromFile(File file, int maxElementsToRead) {
        SAMFileReader reader = new SAMFileReader(file, null);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        DiffNode root = DiffNode.rooted(file.getName());
        SAMRecordIterator iterator = reader.iterator();
        int count = 0;
        while (iterator.hasNext() && (count++ <= maxElementsToRead || maxElementsToRead == -1)) {
            SAMRecord record = (SAMRecord)iterator.next();
            String name = record.getReadName().replace('.', '_');
            if (record.getReadPairedFlag()) {
                name = name + (record.getFirstOfPairFlag() ? "_1" : "_2");
            }
            DiffNode readRoot = DiffNode.empty(name, root);
            readRoot.add("NAME", record.getReadName());
            readRoot.add("FLAGS", record.getFlags());
            readRoot.add("RNAME", record.getReferenceName());
            readRoot.add("POS", record.getAlignmentStart());
            readRoot.add("MAPQ", record.getMappingQuality());
            readRoot.add("CIGAR", record.getCigarString());
            readRoot.add("RNEXT", record.getMateReferenceName());
            readRoot.add("PNEXT", record.getMateAlignmentStart());
            readRoot.add("TLEN", record.getInferredInsertSize());
            readRoot.add("SEQ", record.getReadString());
            readRoot.add("QUAL", record.getBaseQualityString());
            for (SAMRecord.SAMTagAndValue xt : record.getAttributes()) {
                readRoot.add(xt.tag, xt.value);
            }
            if (root.hasElement(name)) continue;
            root.add(readRoot);
        }
        reader.close();
        return root.getBinding();
    }

    @Override
    public boolean canRead(File file) {
        byte[] BAM_MAGIC = "BAM\u0001".getBytes();
        byte[] buffer = new byte[BAM_MAGIC.length];
        try {
            BufferedInputStream fstream = new BufferedInputStream(new FileInputStream(file));
            if (!BlockCompressedInputStream.isValidFile(fstream)) {
                return false;
            }
            new BlockCompressedInputStream(fstream).read(buffer, 0, BAM_MAGIC.length);
            return Arrays.equals(buffer, BAM_MAGIC);
        }
        catch (IOException e) {
            return false;
        }
        catch (FileTruncatedException e) {
            return false;
        }
    }
}

