/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffNode;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffValue;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffableReader;
import org.broadinstitute.sting.gatk.walkers.diffengine.Difference;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class DiffEngine {
    protected static final Logger logger = Logger.getLogger(DiffEngine.class);
    private final Map<String, DiffableReader> readers = new HashMap<String, DiffableReader>();

    public DiffEngine() {
        this.loadDiffableReaders();
    }

    public List<Difference> diff(DiffElement master, DiffElement test) {
        DiffValue masterValue = master.getValue();
        DiffValue testValue = test.getValue();
        if (masterValue.isCompound() && masterValue.isCompound()) {
            return this.diff(master.getValueAsNode(), test.getValueAsNode());
        }
        if (masterValue.isAtomic() && testValue.isAtomic()) {
            return this.diff(masterValue, testValue);
        }
        return Arrays.asList(new Difference(master, test));
    }

    public List<Difference> diff(DiffNode master, DiffNode test) {
        HashSet<String> allNames = new HashSet<String>(master.getElementNames());
        allNames.addAll(test.getElementNames());
        ArrayList<Difference> diffs = new ArrayList<Difference>();
        for (String name : allNames) {
            DiffElement masterElt = master.getElement(name);
            DiffElement testElt = test.getElement(name);
            if (masterElt == null && testElt == null) {
                throw new ReviewedStingException("BUG: unexceptedly got two null elements for field: " + name);
            }
            if (masterElt == null || testElt == null) {
                diffs.add(new Difference(masterElt, testElt));
                continue;
            }
            diffs.addAll(this.diff(masterElt, testElt));
        }
        return diffs;
    }

    public List<Difference> diff(DiffValue master, DiffValue test) {
        if (master.getValue().equals(test.getValue())) {
            return Collections.emptyList();
        }
        return Arrays.asList(new Difference(master.getBinding(), test.getBinding()));
    }

    public void reportSummarizedDifferences(List<Difference> diffs, SummaryReportParams params) {
        this.printSummaryReport(this.summarizeDifferences(diffs), params);
    }

    public List<Difference> summarizeDifferences(List<Difference> diffs) {
        return this.summarizedDifferencesOfPaths(diffs);
    }

    protected static final String[] diffNameToPath(String diffName) {
        return diffName.split("\\.");
    }

    protected List<Difference> summarizedDifferencesOfPathsFromString(List<String> singletonDiffs) {
        ArrayList<Difference> diffs = new ArrayList<Difference>();
        for (String diff : singletonDiffs) {
            diffs.add(new Difference(diff));
        }
        return this.summarizedDifferencesOfPaths(diffs);
    }

    protected List<Difference> summarizedDifferencesOfPaths(List<? extends Difference> singletonDiffs) {
        HashMap<String, Difference> summaries = new HashMap<String, Difference>();
        for (int i = 0; i < singletonDiffs.size(); ++i) {
            for (int j = 0; j <= i; ++j) {
                Difference diffPath1 = singletonDiffs.get(i);
                Difference diffPath2 = singletonDiffs.get(j);
                if (diffPath1.length() != diffPath2.length()) continue;
                int lcp = DiffEngine.longestCommonPostfix(diffPath1.getParts(), diffPath2.getParts());
                String path = diffPath2.getPath();
                if (lcp != 0 && lcp != diffPath1.length()) {
                    path = DiffEngine.summarizedPath(diffPath2.getParts(), lcp);
                }
                Difference sumDiff = new Difference(path, diffPath2.getMaster(), diffPath2.getTest());
                sumDiff.setCount(0);
                this.addSummaryIfMissing(summaries, sumDiff);
            }
        }
        for (Difference difference : singletonDiffs) {
            for (Difference sumDiff : summaries.values()) {
                if (!sumDiff.matches(difference.getParts())) continue;
                sumDiff.incCount();
            }
        }
        ArrayList<Difference> sortedSummaries = new ArrayList<Difference>(summaries.values());
        Collections.sort(sortedSummaries);
        return sortedSummaries;
    }

    protected void addSummaryIfMissing(Map<String, Difference> summaries, Difference diff) {
        if (!summaries.containsKey(diff.getPath())) {
            summaries.put(diff.getPath(), diff);
        }
    }

    protected void printSummaryReport(List<Difference> sortedSummaries, SummaryReportParams params) {
        Difference diff;
        ArrayList<Difference> toShow = new ArrayList<Difference>();
        int count = 0;
        int count1 = 0;
        Iterator<Difference> i$ = sortedSummaries.iterator();
        while (!(!i$.hasNext() || (diff = i$.next()).getCount() < params.minSumDiffToShow || params.maxItemsToDisplay != 0 && count++ > params.maxItemsToDisplay || diff.getCount() == 1 && params.maxCountOneItems != 0 && ++count1 > params.maxCountOneItems)) {
            toShow.add(diff);
        }
        if (!params.descending) {
            Collections.reverse(toShow);
        }
        GATKReport report = new GATKReport();
        String tableName = "differences";
        report.addTable("differences", "Summarized differences between the master and test files. See http://www.broadinstitute.org/gsa/wiki/index.php/DiffEngine for more information", false);
        GATKReportTable table = report.getTable("differences");
        table.addPrimaryKey("Difference", true);
        table.addColumn("NumberOfOccurrences", 0);
        table.addColumn("ExampleDifference", 0);
        for (Difference diff2 : toShow) {
            table.set(diff2.getPath(), "NumberOfOccurrences", diff2.getCount());
            table.set(diff2.getPath(), "ExampleDifference", diff2.valueDiffString());
        }
        table.write(params.out);
    }

    protected static int longestCommonPostfix(String[] diffPath1, String[] diffPath2) {
        int j;
        int i;
        for (i = 0; i < diffPath1.length && diffPath1[j = diffPath1.length - i - 1].equals(diffPath2[j]); ++i) {
        }
        return i;
    }

    protected static String summarizedPath(String[] parts, int commonPostfixLength) {
        int stop = parts.length - commonPostfixLength;
        if (stop > 0) {
            parts = (String[])parts.clone();
        }
        for (int i = 0; i < stop; ++i) {
            parts[i] = "*";
        }
        return Utils.join(".", parts);
    }

    public void loadDiffableReaders() {
        List<Class<DiffableReader>> drClasses = new PluginManager<DiffableReader>(DiffableReader.class).getPlugins();
        logger.info("Loading diffable modules:");
        for (Class<DiffableReader> drClass : drClasses) {
            logger.info("\t" + drClass.getSimpleName());
            try {
                DiffableReader dr = drClass.newInstance();
                this.readers.put(dr.getName(), dr);
            }
            catch (InstantiationException e) {
                throw new ReviewedStingException("Unable to instantiate module '" + drClass.getSimpleName() + "'");
            }
            catch (IllegalAccessException e) {
                throw new ReviewedStingException("Illegal access error when trying to instantiate '" + drClass.getSimpleName() + "'");
            }
        }
    }

    protected Map<String, DiffableReader> getReaders() {
        return this.readers;
    }

    protected DiffableReader getReader(String name) {
        return this.readers.get(name);
    }

    public DiffableReader findReaderForFile(File file) {
        for (DiffableReader reader : this.readers.values()) {
            if (!reader.canRead(file)) continue;
            return reader;
        }
        return null;
    }

    public boolean canRead(File file) {
        return this.findReaderForFile(file) != null;
    }

    public DiffElement createDiffableFromFile(File file) {
        return this.createDiffableFromFile(file, -1);
    }

    public DiffElement createDiffableFromFile(File file, int maxElementsToRead) {
        DiffableReader reader = this.findReaderForFile(file);
        if (reader == null) {
            throw new UserException("Unsupported file type: " + file);
        }
        return reader.readFromFile(file, maxElementsToRead);
    }

    public static boolean simpleDiffFiles(File masterFile, File testFile, int maxElementsToRead, SummaryReportParams params) {
        DiffEngine diffEngine = new DiffEngine();
        if (diffEngine.canRead(masterFile) && diffEngine.canRead(testFile)) {
            DiffElement master = diffEngine.createDiffableFromFile(masterFile, maxElementsToRead);
            DiffElement test = diffEngine.createDiffableFromFile(testFile, maxElementsToRead);
            List<Difference> diffs = diffEngine.diff(master, test);
            diffEngine.reportSummarizedDifferences(diffs, params);
            return true;
        }
        return false;
    }

    public static class SummaryReportParams {
        PrintStream out = System.out;
        int maxItemsToDisplay = 0;
        int maxCountOneItems = 0;
        int minSumDiffToShow = 0;
        boolean descending = true;

        public SummaryReportParams(PrintStream out, int maxItemsToDisplay, int maxCountOneItems, int minSumDiffToShow) {
            this.out = out;
            this.maxItemsToDisplay = maxItemsToDisplay;
            this.maxCountOneItems = maxCountOneItems;
            this.minSumDiffToShow = minSumDiffToShow;
        }

        public void setDescending(boolean descending) {
            this.descending = descending;
        }
    }
}

