/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.samtools.util.StringUtil;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

class PhasingUtils {
    PhasingUtils() {
    }

    static VariantContext mergeIntoMNP(GenomeLocParser genomeLocParser, VariantContext vc1, VariantContext vc2, ReferenceSequenceFile referenceFile, AlleleMergeRule alleleMergeRule) {
        if (!PhasingUtils.mergeIntoMNPvalidationCheck(genomeLocParser, vc1, vc2)) {
            return null;
        }
        if (!PhasingUtils.allSamplesAreMergeable(vc1, vc2)) {
            return null;
        }
        if (!alleleMergeRule.allelesShouldBeMerged(vc1, vc2)) {
            return null;
        }
        return PhasingUtils.reallyMergeIntoMNP(vc1, vc2, referenceFile);
    }

    static VariantContext reallyMergeIntoMNP(VariantContext vc1, VariantContext vc2, ReferenceSequenceFile referenceFile) {
        int startInter = vc1.getEnd() + 1;
        int endInter = vc2.getStart() - 1;
        byte[] intermediateBases = null;
        if (startInter <= endInter) {
            intermediateBases = referenceFile.getSubsequenceAt(vc1.getChr(), startInter, endInter).getBases();
            StringUtil.toUpperCase(intermediateBases);
        }
        MergedAllelesData mergeData = new MergedAllelesData(intermediateBases, vc1, vc2);
        GenotypesContext mergedGenotypes = GenotypesContext.create();
        for (Genotype gt1 : vc1.getGenotypes()) {
            Genotype gt2 = vc2.getGenotype(gt1.getSampleName());
            List<Allele> site1Alleles = gt1.getAlleles();
            List<Allele> site2Alleles = gt2.getAlleles();
            LinkedList<Allele> mergedAllelesForSample = new LinkedList<Allele>();
            Iterator<Allele> all2It = site2Alleles.iterator();
            for (Allele all1 : site1Alleles) {
                Allele all2 = all2It.next();
                Allele mergedAllele = mergeData.ensureMergedAllele(all1, all2);
                mergedAllelesForSample.add(mergedAllele);
            }
            double mergedGQ = Math.max(gt1.getLog10PError(), gt2.getLog10PError());
            HashSet<String> mergedGtFilters = new HashSet<String>();
            HashMap<String, Object> mergedGtAttribs = new HashMap<String, Object>();
            PhaseAndQuality phaseQual = PhasingUtils.calcPhaseForMergedGenotypes(gt1, gt2);
            if (phaseQual.PQ != null) {
                mergedGtAttribs.put("PQ", phaseQual.PQ);
            }
            Genotype mergedGt = new Genotype(gt1.getSampleName(), mergedAllelesForSample, mergedGQ, mergedGtFilters, mergedGtAttribs, phaseQual.isPhased);
            mergedGenotypes.add(mergedGt);
        }
        String mergedName = PhasingUtils.mergeVariantContextNames(vc1.getSource(), vc2.getSource());
        double mergedLog10PError = Math.min(vc1.getLog10PError(), vc2.getLog10PError());
        HashSet<String> mergedFilters = new HashSet<String>();
        Map<String, Object> mergedAttribs = PhasingUtils.mergeVariantContextAttributes(vc1, vc2);
        ArrayList<String> mergedIDs = new ArrayList<String>();
        if (vc1.hasID()) {
            mergedIDs.add(vc1.getID());
        }
        if (vc2.hasID()) {
            mergedIDs.add(vc2.getID());
        }
        String mergedID = mergedIDs.isEmpty() ? "." : Utils.join(";", mergedIDs);
        VariantContextBuilder mergedBuilder = new VariantContextBuilder(mergedName, vc1.getChr(), vc1.getStart(), vc2.getEnd(), mergeData.getAllMergedAlleles()).id(mergedID).genotypes(mergedGenotypes).log10PError(mergedLog10PError).filters(mergedFilters).attributes(mergedAttribs);
        VariantContextUtils.calculateChromosomeCounts(mergedBuilder, true);
        return mergedBuilder.make();
    }

    static String mergeVariantContextNames(String name1, String name2) {
        return name1 + "_" + name2;
    }

    static Map<String, Object> mergeVariantContextAttributes(VariantContext vc1, VariantContext vc2) {
        String[] MERGE_OR_ATTRIBS;
        HashMap<String, Object> mergedAttribs = new HashMap<String, Object>();
        LinkedList<VariantContext> vcList = new LinkedList<VariantContext>();
        vcList.add(vc1);
        vcList.add(vc2);
        for (String orAttrib : MERGE_OR_ATTRIBS = new String[]{"DB"}) {
            VariantContext vc;
            boolean attribVal = false;
            Iterator i$ = vcList.iterator();
            while (i$.hasNext() && !(attribVal = (vc = (VariantContext)i$.next()).getAttributeAsBoolean(orAttrib, false))) {
            }
            mergedAttribs.put(orAttrib, attribVal);
        }
        return mergedAttribs;
    }

    static boolean mergeIntoMNPvalidationCheck(GenomeLocParser genomeLocParser, VariantContext vc1, VariantContext vc2) {
        GenomeLoc loc2;
        GenomeLoc loc1 = VariantContextUtils.getLocation(genomeLocParser, vc1);
        if (!loc1.onSameContig(loc2 = VariantContextUtils.getLocation(genomeLocParser, vc2))) {
            throw new ReviewedStingException("Can only merge vc1, vc2 if on the same chromosome");
        }
        if (!loc1.isBefore(loc2)) {
            throw new ReviewedStingException("Can only merge if vc1 is BEFORE vc2");
        }
        if (vc1.isFiltered() || vc2.isFiltered()) {
            return false;
        }
        if (!((Object)vc1.getSampleNames()).equals(vc2.getSampleNames())) {
            return false;
        }
        return PhasingUtils.allGenotypesAreUnfilteredAndCalled(vc1) && PhasingUtils.allGenotypesAreUnfilteredAndCalled(vc2);
    }

    static boolean allGenotypesAreUnfilteredAndCalled(VariantContext vc) {
        for (Genotype gt : vc.getGenotypes()) {
            if (!gt.isNoCall() && !gt.isFiltered()) continue;
            return false;
        }
        return true;
    }

    static boolean allSamplesAreMergeable(VariantContext vc1, VariantContext vc2) {
        for (Genotype gt1 : vc1.getGenotypes()) {
            Genotype gt2;
            if (PhasingUtils.alleleSegregationIsKnown(gt1, gt2 = vc2.getGenotype(gt1.getSampleName()))) continue;
            return false;
        }
        return true;
    }

    static boolean alleleSegregationIsKnown(Genotype gt1, Genotype gt2) {
        if (gt1.getPloidy() != gt2.getPloidy()) {
            return false;
        }
        return gt2.isPhased() || gt2.isHom() || gt1.isHom();
    }

    static PhaseAndQuality calcPhaseForMergedGenotypes(Genotype gt1, Genotype gt2) {
        if (gt2.isPhased() || gt2.isHom()) {
            return new PhaseAndQuality(gt1);
        }
        if (!gt1.isHom()) {
            throw new ReviewedStingException("alleleSegregationIsKnown(gt1, gt2) implies: gt2.genotypesArePhased() || gt2.isHom() || gt1.isHom()");
        }
        return new PhaseAndQuality(gt2);
    }

    static boolean someSampleHasDoubleNonReferenceAllele(VariantContext vc1, VariantContext vc2) {
        for (Genotype gt1 : vc1.getGenotypes()) {
            Genotype gt2 = vc2.getGenotype(gt1.getSampleName());
            List<Allele> site1Alleles = gt1.getAlleles();
            List<Allele> site2Alleles = gt2.getAlleles();
            Iterator<Allele> all2It = site2Alleles.iterator();
            for (Allele all1 : site1Alleles) {
                Allele all2 = all2It.next();
                if (!all1.isNonReference() || !all2.isNonReference()) continue;
                return true;
            }
        }
        return false;
    }

    static boolean doubleAllelesSegregatePerfectlyAmongSamples(VariantContext vc1, VariantContext vc2) {
        HashMap<Allele, Allele> allele1ToAllele2 = new HashMap<Allele, Allele>();
        HashMap<Allele, Allele> allele2ToAllele1 = new HashMap<Allele, Allele>();
        allele1ToAllele2.put(vc1.getReference(), vc2.getReference());
        allele2ToAllele1.put(vc2.getReference(), vc1.getReference());
        for (Genotype gt1 : vc1.getGenotypes()) {
            Genotype gt2 = vc2.getGenotype(gt1.getSampleName());
            List<Allele> site1Alleles = gt1.getAlleles();
            List<Allele> site2Alleles = gt2.getAlleles();
            Iterator<Allele> all2It = site2Alleles.iterator();
            for (Allele all1 : site1Alleles) {
                Allele all2 = all2It.next();
                Allele all1To2 = (Allele)allele1ToAllele2.get(all1);
                if (all1To2 == null) {
                    allele1ToAllele2.put(all1, all2);
                } else if (!all1To2.equals(all2)) {
                    return false;
                }
                Allele all2To1 = (Allele)allele2ToAllele1.get(all2);
                if (all2To1 == null) {
                    allele2ToAllele1.put(all2, all1);
                    continue;
                }
                if (all2To1.equals(all1)) continue;
                return false;
            }
        }
        return true;
    }

    static class PhaseAndQuality {
        public boolean isPhased;
        public Double PQ = null;

        public PhaseAndQuality(Genotype gt) {
            this.isPhased = gt.isPhased();
            if (this.isPhased) {
                this.PQ = gt.getAttributeAsDouble("PQ", -1.0);
                if (this.PQ == -1.0) {
                    this.PQ = null;
                }
            }
        }
    }

    static class MergedAllelesData {
        private Map<AlleleOneAndTwo, Allele> mergedAlleles = new HashMap<AlleleOneAndTwo, Allele>();
        private byte[] intermediateBases;
        private int intermediateLength;

        public MergedAllelesData(byte[] intermediateBases, VariantContext vc1, VariantContext vc2) {
            this.intermediateBases = intermediateBases;
            this.intermediateLength = this.intermediateBases != null ? this.intermediateBases.length : 0;
            this.ensureMergedAllele(vc1.getReference(), vc2.getReference(), true);
        }

        public Allele ensureMergedAllele(Allele all1, Allele all2) {
            return this.ensureMergedAllele(all1, all2, false);
        }

        private Allele ensureMergedAllele(Allele all1, Allele all2, boolean creatingReferenceForFirstTime) {
            AlleleOneAndTwo all12 = new AlleleOneAndTwo(all1, all2);
            Allele mergedAllele = this.mergedAlleles.get(all12);
            if (mergedAllele == null) {
                byte[] bases1 = all1.getBases();
                byte[] bases2 = all2.getBases();
                byte[] mergedBases = new byte[bases1.length + this.intermediateLength + bases2.length];
                System.arraycopy(bases1, 0, mergedBases, 0, bases1.length);
                if (this.intermediateBases != null) {
                    System.arraycopy(this.intermediateBases, 0, mergedBases, bases1.length, this.intermediateLength);
                }
                System.arraycopy(bases2, 0, mergedBases, bases1.length + this.intermediateLength, bases2.length);
                mergedAllele = Allele.create(mergedBases, creatingReferenceForFirstTime);
                this.mergedAlleles.put(all12, mergedAllele);
            }
            return mergedAllele;
        }

        public Set<Allele> getAllMergedAlleles() {
            return new HashSet<Allele>(this.mergedAlleles.values());
        }
    }

    static class AlleleOneAndTwo {
        private Allele all1;
        private Allele all2;

        public AlleleOneAndTwo(Allele all1, Allele all2) {
            this.all1 = all1;
            this.all2 = all2;
        }

        public int hashCode() {
            return this.all1.hashCode() + this.all2.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof AlleleOneAndTwo)) {
                return false;
            }
            AlleleOneAndTwo otherAot = (AlleleOneAndTwo)other;
            return this.all1.equals(otherAot.all1) && this.all2.equals(otherAot.all2);
        }
    }

    static abstract class AlleleMergeRule {
        AlleleMergeRule() {
        }

        public abstract boolean allelesShouldBeMerged(VariantContext var1, VariantContext var2);

        public String toString() {
            return "all samples are mergeable";
        }
    }
}

