/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.MappingQualityZeroFilter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.phasing.CardinalityCounter;
import org.broadinstitute.sting.gatk.walkers.phasing.CloneableIteratorLinkedList;
import org.broadinstitute.sting.gatk.walkers.phasing.DisjointSet;
import org.broadinstitute.sting.gatk.walkers.phasing.Haplotype;
import org.broadinstitute.sting.gatk.walkers.phasing.HaplotypeClass;
import org.broadinstitute.sting.gatk.walkers.phasing.MergeSegregatingAlternateAllelesVCFWriter;
import org.broadinstitute.sting.gatk.walkers.phasing.MultipleBaseCounts;
import org.broadinstitute.sting.gatk.walkers.phasing.PhaseCounts;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingGraph;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingGraphEdge;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingQualityStatsWriter;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingRead;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingScore;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingStats;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingStatsAndOutput;
import org.broadinstitute.sting.gatk.walkers.phasing.PreciseNonNegativeDouble;
import org.broadinstitute.sting.gatk.walkers.phasing.ReadBase;
import org.broadinstitute.sting.gatk.walkers.phasing.ReadBasesAtPosition;
import org.broadinstitute.sting.gatk.walkers.phasing.SNPallelePair;
import org.broadinstitute.sting.gatk.walkers.phasing.SampleReadLocus;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.codecs.vcf.SortingVCFWriter;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Allows(value={DataSource.READS, DataSource.REFERENCE})
@Requires(value={DataSource.READS, DataSource.REFERENCE})
@By(value=DataSource.READS)
@ReadFilters(value={MappingQualityZeroFilter.class})
public class ReadBackedPhasingWalker
extends RodWalker<PhasingStatsAndOutput, PhasingStats> {
    private static final boolean DEBUG = false;
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter writer = null;
    @Argument(fullName="cacheWindowSize", shortName="cacheWindow", doc="The window size (in bases) to cache variant sites and their reads for the phasing procedure", required=false)
    protected Integer cacheWindow = 20000;
    @Argument(fullName="maxPhaseSites", shortName="maxSites", doc="The maximum number of successive heterozygous sites permitted to be used by the phasing algorithm", required=false)
    protected Integer maxPhaseSites = 10;
    @Argument(fullName="phaseQualityThresh", shortName="phaseThresh", doc="The minimum phasing quality score required to output phasing", required=false)
    protected Double phaseQualityThresh = 10.0;
    @Hidden
    @Argument(fullName="variantStatsFilePrefix", shortName="variantStats", doc="The prefix of the VCF/phasing statistics files [For DEBUGGING purposes only - DO NOT USE!]", required=false)
    protected String variantStatsFilePrefix = null;
    private PhasingQualityStatsWriter statsWriter = null;
    @Argument(fullName="min_base_quality_score", shortName="mbq", doc="Minimum base quality required to consider a base for phasing", required=false)
    public int MIN_BASE_QUALITY_SCORE = 17;
    @Argument(fullName="min_mapping_quality_score", shortName="mmq", doc="Minimum read mapping quality required to consider a read for phasing", required=false)
    public int MIN_MAPPING_QUALITY_SCORE = 20;
    @Argument(fullName="sampleToPhase", shortName="sampleToPhase", doc="Only include these samples when phasing", required=false)
    protected Set<String> samplesToPhase = null;
    private GenomeLoc mostDownstreamLocusReached = null;
    private LinkedList<VariantAndReads> unphasedSiteQueue = null;
    private CloneableIteratorLinkedList<UnfinishedVariantAndReads> partiallyPhasedSites = null;
    private static PreciseNonNegativeDouble ZERO = new PreciseNonNegativeDouble(0.0);
    public static final String PQ_KEY = "PQ";
    private static final double FRACTION_OF_MEAN_PQ_CHANGES = 0.1;
    private static final double MAX_FRACTION_OF_INCONSISTENT_READS = 0.1;
    public static final String PHASING_INCONSISTENT_KEY = "PhasingInconsistent";
    @Argument(fullName="enableMergePhasedSegregatingPolymorphismsToMNP", shortName="enableMergeToMNP", doc="Merge consecutive phased sites into MNP records", required=false)
    protected boolean enableMergePhasedSegregatingPolymorphismsToMNP = false;
    @Argument(fullName="maxGenomicDistanceForMNP", shortName="maxDistMNP", doc="The maximum reference-genome distance between consecutive heterozygous sites to permit merging phased VCF records into a MNP record", required=false)
    protected int maxGenomicDistanceForMNP = 1;
    @Hidden
    @Argument(fullName="outputMultipleBaseCountsFile", shortName="outputMultipleBaseCountsFile", doc="File to output cases where a single read has multiple bases at the same position [For DEBUGGING purposes only - DO NOT USE!]", required=false)
    protected File outputMultipleBaseCountsFile = null;
    private MultipleBaseCountsWriter outputMultipleBaseCountsWriter = null;
    private static final Set<String> KEYS_TO_KEEP_IN_REDUCED_VCF = new HashSet<String>(Arrays.asList("PQ"));

    @Override
    public void initialize() {
        if (this.maxPhaseSites <= 2) {
            this.maxPhaseSites = 2;
        }
        this.MIN_MAPPING_QUALITY_SCORE = Math.max(this.MIN_MAPPING_QUALITY_SCORE, this.MIN_BASE_QUALITY_SCORE);
        this.unphasedSiteQueue = new LinkedList();
        this.partiallyPhasedSites = new CloneableIteratorLinkedList();
        this.initializeVcfWriter();
        if (this.variantStatsFilePrefix != null) {
            this.statsWriter = new PhasingQualityStatsWriter(this.variantStatsFilePrefix);
        }
        if (this.outputMultipleBaseCountsFile != null) {
            this.outputMultipleBaseCountsWriter = new MultipleBaseCountsWriter(this.outputMultipleBaseCountsFile);
        }
    }

    private void initializeVcfWriter() {
        VCFWriter origWriter = this.writer;
        if (this.enableMergePhasedSegregatingPolymorphismsToMNP) {
            this.writer = new MergeSegregatingAlternateAllelesVCFWriter(this.writer, this.getToolkit().getGenomeLocParser(), this.getToolkit().getArguments().referenceFile, this.maxGenomicDistanceForMNP, logger, this.writer != origWriter);
        }
        this.writer = new SortingVCFWriter(this.writer, 2 * this.cacheWindow, this.writer != origWriter);
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(VCFUtils.getHeaderFields(this.getToolkit()));
        hInfo.add(new VCFHeaderLine("reference", this.getToolkit().getArguments().referenceFile.getName()));
        hInfo.add(new VCFFormatHeaderLine(PQ_KEY, 1, VCFHeaderLineType.Float, "Read-backed phasing quality"));
        hInfo.add(new VCFInfoHeaderLine(PHASING_INCONSISTENT_KEY, 0, VCFHeaderLineType.Flag, "Are the reads significantly haplotype-inconsistent?"));
        String trackName = this.variantCollection.variants.getName();
        Map<String, VCFHeader> rodNameToHeader = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(trackName));
        TreeSet<String> samples = new TreeSet<String>(this.samplesToPhase == null ? rodNameToHeader.get(trackName).getGenotypeSamples() : this.samplesToPhase);
        this.writer.writeHeader(new VCFHeader(hInfo, samples));
    }

    @Override
    public boolean generateExtendedEvents() {
        return false;
    }

    @Override
    public PhasingStats reduceInit() {
        return new PhasingStats();
    }

    @Override
    public PhasingStatsAndOutput map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        this.mostDownstreamLocusReached = ref.getLocus();
        PhasingStats phaseStats = new PhasingStats();
        LinkedList<VariantContext> unprocessedList = new LinkedList<VariantContext>();
        for (VariantContext vc : tracker.getValues(this.variantCollection.variants, context.getLocation())) {
            if (this.samplesToPhase != null) {
                vc = this.reduceVCToSamples(vc, this.samplesToPhase);
            }
            if (ReadBackedPhasingWalker.processVariantInPhasing(vc)) {
                VariantAndReads vr = new VariantAndReads(vc, context);
                this.unphasedSiteQueue.add(vr);
            } else {
                unprocessedList.add(vc);
            }
            int numReads = 0;
            if (context.hasBasePileup()) {
                numReads = context.getBasePileup().getNumberOfElements();
            } else if (context.hasExtendedEventPileup()) {
                numReads = context.getExtendedEventPileup().getNumberOfElements();
            }
            PhasingStats addInPhaseStats = new PhasingStats(numReads, 1);
            phaseStats.addIn(addInPhaseStats);
        }
        List<VariantContext> completedList = this.processQueue(phaseStats, false);
        completedList.addAll(unprocessedList);
        return new PhasingStatsAndOutput(phaseStats, completedList);
    }

    private VariantContext reduceVCToSamples(VariantContext vc, Set<String> samplesToPhase) {
        VariantContext subvc = vc.subContextFromSamples(samplesToPhase);
        return VariantContextUtils.pruneVariantContext(subvc, KEYS_TO_KEEP_IN_REDUCED_VCF);
    }

    private List<VariantContext> processQueue(PhasingStats phaseStats, boolean processAll) {
        LinkedList<VariantContext> oldPhasedList = new LinkedList<VariantContext>();
        while (!this.unphasedSiteQueue.isEmpty()) {
            if (!processAll) {
                VariantContext nextToPhaseVc = this.unphasedSiteQueue.peek().variant;
                if (this.startDistancesAreInWindowRange(this.mostDownstreamLocusReached, VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), nextToPhaseVc))) break;
            }
            oldPhasedList.addAll(this.discardIrrelevantPhasedSites());
            VariantAndReads vr = this.unphasedSiteQueue.remove();
            this.phaseSite(vr, phaseStats);
        }
        oldPhasedList.addAll(this.discardIrrelevantPhasedSites());
        if (this.outputMultipleBaseCountsWriter != null) {
            this.outputMultipleBaseCountsWriter.outputMultipleBaseCounts();
        }
        return oldPhasedList;
    }

    private List<VariantContext> discardIrrelevantPhasedSites() {
        LinkedList<VariantContext> vcList = new LinkedList<VariantContext>();
        GenomeLoc nextToPhaseLoc = null;
        if (!this.unphasedSiteQueue.isEmpty()) {
            nextToPhaseLoc = VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), this.unphasedSiteQueue.peek().variant);
        }
        while (!this.partiallyPhasedSites.isEmpty()) {
            if (nextToPhaseLoc != null) {
                UnfinishedVariantAndReads partPhasedVr = this.partiallyPhasedSites.peek();
                if (this.startDistancesAreInWindowRange(partPhasedVr.unfinishedVariant.getLocation(), nextToPhaseLoc)) break;
            }
            UnfinishedVariantAndReads uvr = this.partiallyPhasedSites.remove();
            vcList.add(uvr.unfinishedVariant.toVariantContext());
        }
        return vcList;
    }

    private void phaseSite(VariantAndReads vr, PhasingStats phaseStats) {
        VariantContext vc = vr.variant;
        logger.debug("Will phase vc = " + VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), vc));
        UnfinishedVariantAndReads uvr = new UnfinishedVariantAndReads(vr);
        UnfinishedVariantContext uvc = uvr.unfinishedVariant;
        GenotypesContext sampGenotypes = vc.getGenotypes();
        TreeMap<String, PhaseCounts> samplePhaseStats = new TreeMap<String, PhaseCounts>();
        for (Genotype gt : sampGenotypes) {
            PhaseCounts sampPhaseCounts;
            PhasingWindow phaseWindow;
            String samp = gt.getSampleName();
            if (!ReadBackedPhasingWalker.isUnfilteredCalledDiploidGenotype(gt)) continue;
            if (gt.isHom()) {
                Genotype phasedGt = new Genotype(gt.getSampleName(), gt.getAlleles(), gt.getLog10PError(), gt.getFilters(), gt.getAttributes(), true);
                uvc.setGenotype(samp, phasedGt);
                continue;
            }
            if (!gt.isHet() || !(phaseWindow = new PhasingWindow(vr, samp)).hasPreviousHets()) continue;
            SNPallelePair allelePair = new SNPallelePair(gt);
            CloneableIteratorLinkedList.CloneableIterator prevHetAndInteriorIt = phaseWindow.prevHetAndInteriorIt;
            UnfinishedVariantContext prevUvc = ((UnfinishedVariantAndReads)prevHetAndInteriorIt.next()).unfinishedVariant;
            Genotype prevHetGenotype = prevUvc.getGenotype(samp);
            PhaseResult pr = this.phaseSampleAtSite(phaseWindow);
            boolean genotypesArePhased = this.passesPhasingThreshold(pr.phaseQuality);
            if (pr.phasingContainsInconsistencies) {
                uvc.setPhasingInconsistent();
            }
            if (genotypesArePhased) {
                SNPallelePair prevAllelePair = new SNPallelePair(prevHetGenotype);
                ReadBackedPhasingWalker.ensurePhasing(allelePair, prevAllelePair, pr.haplotype);
                HashMap<String, Object> gtAttribs = new HashMap<String, Object>(gt.getAttributes());
                gtAttribs.put(PQ_KEY, pr.phaseQuality);
                Genotype phasedGt = new Genotype(gt.getSampleName(), allelePair.getAllelesAsList(), gt.getLog10PError(), gt.getFilters(), gtAttribs, genotypesArePhased);
                uvc.setGenotype(samp, phasedGt);
            }
            while (prevHetAndInteriorIt.hasNext()) {
                UnfinishedVariantContext interiorUvc = ((UnfinishedVariantAndReads)prevHetAndInteriorIt.next()).unfinishedVariant;
                Genotype handledGt = interiorUvc.getGenotype(samp);
                if (handledGt == null || !ReadBackedPhasingWalker.isUnfilteredCalledDiploidGenotype(handledGt)) {
                    throw new ReviewedStingException("LOGICAL error: should not have breaks WITHIN haplotype");
                }
                if (!handledGt.isHom()) {
                    throw new ReviewedStingException("LOGICAL error: should not have anything besides hom sites IN BETWEEN two het sites");
                }
                if (pr.phasingContainsInconsistencies) {
                    interiorUvc.setPhasingInconsistent();
                }
                if (!genotypesArePhased) continue;
                HashMap<String, Object> handledGtAttribs = new HashMap<String, Object>(handledGt.getAttributes());
                handledGtAttribs.put(PQ_KEY, pr.phaseQuality);
                Genotype phasedHomGt = new Genotype(handledGt.getSampleName(), handledGt.getAlleles(), handledGt.getLog10PError(), handledGt.getFilters(), handledGtAttribs, genotypesArePhased);
                interiorUvc.setGenotype(samp, phasedHomGt);
            }
            if (this.statsWriter != null) {
                this.statsWriter.addStat(samp, VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), vc), this.startDistance(prevUvc, vc), pr.phaseQuality, phaseWindow.readsAtHetSites.size(), phaseWindow.hetGenotypes.length);
            }
            if ((sampPhaseCounts = (PhaseCounts)samplePhaseStats.get(samp)) == null) {
                sampPhaseCounts = new PhaseCounts();
                samplePhaseStats.put(samp, sampPhaseCounts);
            }
            ++sampPhaseCounts.numTestedSites;
            if (pr.phasingContainsInconsistencies) {
                if (genotypesArePhased) {
                    ++sampPhaseCounts.numInconsistentSitesPhased;
                } else {
                    ++sampPhaseCounts.numInconsistentSitesNotPhased;
                }
            }
            if (!genotypesArePhased) continue;
            ++sampPhaseCounts.numPhased;
        }
        this.partiallyPhasedSites.add(uvr);
        phaseStats.addIn(new PhasingStats(samplePhaseStats));
    }

    public boolean passesPhasingThreshold(double PQ) {
        return PQ >= this.phaseQualityThresh;
    }

    private PhaseResult phaseSampleAtSite(PhasingWindow phaseWindow) {
        TableCreatorOfHaplotypeAndComplementForDiploidAlleles tabCreator = new TableCreatorOfHaplotypeAndComplementForDiploidAlleles(phaseWindow.hetGenotypes, phaseWindow.phasingSiteIndex - 1, 2);
        PhasingTable sampleHaps = ((HaplotypeTableCreator)tabCreator).getNewTable();
        MaxHaplotypeAndQuality prevMaxHapAndQual = null;
        int numHighQualityIterations = 0;
        int numInconsistentIterations = 0;
        double totalAbsPQchange = 0.0;
        int numPQchangesObserved = 0;
        for (Map.Entry nameToReads : phaseWindow.readsAtHetSites.entrySet()) {
            PhasingRead rd = (PhasingRead)nameToReads.getValue();
            for (PhasingTable.PhasingTableEntry pte : sampleHaps) {
                PhasingScore score = rd.matchHaplotypeClassScore(pte.getHaplotypeClass());
                pte.getScore().integrateReadScore(score);
            }
            MaxHaplotypeAndQuality curMaxHapAndQual = new MaxHaplotypeAndQuality(sampleHaps, false);
            if (prevMaxHapAndQual != null) {
                double changeInPQ = prevMaxHapAndQual.phaseQuality - curMaxHapAndQual.phaseQuality;
                if (this.passesPhasingThreshold(prevMaxHapAndQual.phaseQuality)) {
                    ++numHighQualityIterations;
                    if (!curMaxHapAndQual.hasSameRepresentativeHaplotype(prevMaxHapAndQual) || numPQchangesObserved > 0 && changeInPQ > 0.1 * (totalAbsPQchange / (double)numPQchangesObserved)) {
                        ++numInconsistentIterations;
                    }
                }
                totalAbsPQchange += Math.abs(changeInPQ);
                ++numPQchangesObserved;
            }
            prevMaxHapAndQual = curMaxHapAndQual;
        }
        MaxHaplotypeAndQuality maxHapQual = new MaxHaplotypeAndQuality(sampleHaps, true);
        double posteriorProb = maxHapQual.maxEntry.getScore().getValue();
        boolean phasingContainsInconsistencies = false;
        if ((double)numInconsistentIterations / (double)numHighQualityIterations > 0.1) {
            phasingContainsInconsistencies = true;
        }
        return new PhaseResult(maxHapQual.getRepresentative(), maxHapQual.phaseQuality, phasingContainsInconsistencies);
    }

    public static void ensurePhasing(SNPallelePair curAllelePair, SNPallelePair prevAllelePair, Haplotype hap) {
        boolean choseCurTopChrom;
        if (hap.size() < 2) {
            throw new ReviewedStingException("LOGICAL ERROR: Only considering haplotypes of length > 2!");
        }
        byte prevBase = hap.getBase(0);
        byte curBase = hap.getBase(1);
        boolean chosePrevTopChrom = prevAllelePair.matchesTopBase(prevBase);
        if (chosePrevTopChrom != (choseCurTopChrom = curAllelePair.matchesTopBase(curBase))) {
            curAllelePair.swapAlleles();
        }
    }

    private boolean startDistancesAreInWindowRange(VariantContext vc1, VariantContext vc2) {
        return this.startDistancesAreInWindowRange(VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), vc1), VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), vc2));
    }

    private boolean startDistancesAreInWindowRange(GenomeLoc loc1, GenomeLoc loc2) {
        return loc1.distance(loc2) <= this.cacheWindow;
    }

    private int startDistance(UnfinishedVariantContext uvc1, VariantContext vc2) {
        return uvc1.getLocation().distance(VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), vc2));
    }

    @Override
    public PhasingStats reduce(PhasingStatsAndOutput statsAndList, PhasingStats stats) {
        if (statsAndList != null) {
            this.writeVcList(statsAndList.output);
            stats.addIn(statsAndList.ps);
        }
        return stats;
    }

    @Override
    public void onTraversalDone(PhasingStats result) {
        List<VariantContext> finalList = this.processQueue(result, true);
        this.writeVcList(finalList);
        this.writer.close();
        if (this.statsWriter != null) {
            this.statsWriter.close();
        }
        if (this.outputMultipleBaseCountsWriter != null) {
            this.outputMultipleBaseCountsWriter.close();
        }
        System.out.println("Coverage over ALL samples:");
        System.out.println("Number of reads observed: " + result.getNumReads());
        System.out.println("Number of variant sites observed: " + result.getNumVarSites());
        System.out.println("Average coverage: " + (double)result.getNumReads() / (double)result.getNumVarSites());
        System.out.println("\n--- Phasing summary [minimal haplotype quality (PQ): " + this.phaseQualityThresh + ", maxPhaseSites: " + this.maxPhaseSites + ", cacheWindow: " + this.cacheWindow + "] ---");
        for (Map.Entry<String, PhaseCounts> sampPhaseCountEntry : result.getPhaseCounts()) {
            PhaseCounts pc = sampPhaseCountEntry.getValue();
            System.out.print("Sample: " + sampPhaseCountEntry.getKey() + "\tSites tested: " + pc.numTestedSites + "\tSites phased: " + pc.numPhased);
            System.out.println("\tPhase-inconsistent sites: " + (pc.numInconsistentSitesPhased + pc.numInconsistentSitesNotPhased) + " [phased: " + pc.numInconsistentSitesPhased + ", unphased:" + pc.numInconsistentSitesNotPhased + "]");
        }
        System.out.println("");
    }

    private void writeVcList(List<VariantContext> varContList) {
        for (VariantContext vc : varContList) {
            this.writeVCF(vc);
        }
    }

    private void writeVCF(VariantContext vc) {
        if (this.samplesToPhase == null || vc.isNotFiltered()) {
            this.writer.add(vc);
        }
    }

    public static boolean processVariantInPhasing(VariantContext vc) {
        return vc.isNotFiltered() && (vc.isSNP() && vc.isBiallelic() || !vc.isVariant());
    }

    private static String toStringGRL(List<GenotypeAndReadBases> grbList) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (GenotypeAndReadBases grb : grbList) {
            if (first) {
                first = false;
            } else {
                sb.append(" -- ");
            }
            sb.append(grb.loc);
        }
        return sb.toString();
    }

    private String toStringVCL(List<VariantContext> vcList) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (VariantContext vc : vcList) {
            if (first) {
                first = false;
            } else {
                sb.append(" -- ");
            }
            sb.append(VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), vc));
        }
        return sb.toString();
    }

    public static boolean isUnfilteredBiallelicSNP(VariantContext vc) {
        return vc.isNotFiltered() && vc.isSNP() && vc.isBiallelic();
    }

    public static boolean isUnfilteredCalledDiploidGenotype(Genotype gt) {
        return gt.isNotFiltered() && gt.isCalled() && gt.getPloidy() == 2;
    }

    private class MultipleBaseCountsWriter {
        private BufferedWriter writer = null;
        private TreeMap<SampleReadLocus, MultipleBaseCounts> multipleBaseCounts = null;

        public MultipleBaseCountsWriter(File outputMultipleBaseCountsFile) {
            FileOutputStream output;
            try {
                output = new FileOutputStream(outputMultipleBaseCountsFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Unable to create multiple base count file at location: " + outputMultipleBaseCountsFile);
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(output));
            this.multipleBaseCounts = new TreeMap();
        }

        public void setMultipleBases(SampleReadLocus srl, GenomeLoc phasingLoc, byte prevBase, byte newBase) {
            MultipleBaseCounts mbc = this.multipleBaseCounts.get(srl);
            if (mbc == null) {
                mbc = new MultipleBaseCounts(phasingLoc);
                mbc.incrementBaseCount(prevBase);
                this.multipleBaseCounts.put(srl, mbc);
            }
            if (mbc.samePhasingLocAs(phasingLoc)) {
                mbc.incrementBaseCount(newBase);
            }
        }

        public void outputMultipleBaseCounts() {
            GenomeLoc nextToPhaseLoc = null;
            if (!ReadBackedPhasingWalker.this.unphasedSiteQueue.isEmpty()) {
                nextToPhaseLoc = VariantContextUtils.getLocation(ReadBackedPhasingWalker.this.getToolkit().getGenomeLocParser(), ((VariantAndReads)((ReadBackedPhasingWalker)ReadBackedPhasingWalker.this).unphasedSiteQueue.peek()).variant);
            }
            this.outputMultipleBaseCounts(nextToPhaseLoc);
        }

        private void outputMultipleBaseCounts(GenomeLoc nextToPhaseLoc) {
            try {
                Iterator<Map.Entry<SampleReadLocus, MultipleBaseCounts>> multBaseCountIt = this.multipleBaseCounts.entrySet().iterator();
                while (multBaseCountIt.hasNext()) {
                    Map.Entry<SampleReadLocus, MultipleBaseCounts> sampleReadLocBaseCountsEntry = multBaseCountIt.next();
                    SampleReadLocus srl = sampleReadLocBaseCountsEntry.getKey();
                    if (nextToPhaseLoc != null && ReadBackedPhasingWalker.this.startDistancesAreInWindowRange(srl.getLocus(), nextToPhaseLoc)) continue;
                    this.writer.write(srl + "\t" + sampleReadLocBaseCountsEntry.getValue() + "\n");
                    multBaseCountIt.remove();
                }
                this.writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write to outputMultipleBaseCountsFile", e);
            }
        }

        public void close() {
            this.outputMultipleBaseCounts(null);
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close outputMultipleBaseCountsFile");
            }
        }
    }

    private static class PhaseResult {
        public Haplotype haplotype;
        public double phaseQuality;
        public boolean phasingContainsInconsistencies;

        public PhaseResult(Haplotype haplotype, double phaseQuality, boolean phasingContainsInconsistencies) {
            this.haplotype = haplotype;
            this.phaseQuality = phaseQuality;
            this.phasingContainsInconsistencies = phasingContainsInconsistencies;
        }
    }

    private static class PhasingTable
    implements Iterable<PhasingTableEntry> {
        private LinkedList<PhasingTableEntry> table = new LinkedList();

        public PhasingTableEntry addEntry(HaplotypeClass haplotypeClass, PreciseNonNegativeDouble initialScore) {
            PhasingTableEntry pte = new PhasingTableEntry(haplotypeClass, new PhasingScore(initialScore));
            this.table.add(pte);
            return pte;
        }

        public PhasingTableEntry addEntry(HaplotypeClass haplotypeClass, double initialScore) {
            return this.addEntry(haplotypeClass, new PreciseNonNegativeDouble(initialScore));
        }

        @Override
        public Iterator<PhasingTableEntry> iterator() {
            return this.table.iterator();
        }

        public boolean isEmpty() {
            return this.table.isEmpty();
        }

        public PhasingTableEntry maxEntry() {
            if (this.table.isEmpty()) {
                return null;
            }
            PhasingTableEntry maxPte = null;
            for (PhasingTableEntry pte : this.table) {
                if (maxPte != null && !pte.getScore().gt(maxPte.getScore())) continue;
                maxPte = pte;
            }
            return maxPte;
        }

        public void normalizeScores() {
            PreciseNonNegativeDouble normalizeBy = new PreciseNonNegativeDouble(ZERO);
            for (PhasingTableEntry pte : this.table) {
                normalizeBy.plusEqual(pte.getScore());
            }
            if (!normalizeBy.equals(ZERO)) {
                for (PhasingTableEntry pte : this.table) {
                    pte.getScore().divEqual(normalizeBy);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("-------------------\n");
            for (PhasingTableEntry pte : this) {
                sb.append("Haplotypes:\t" + pte.getHaplotypeClass() + "\tScore:\t" + pte.getScore() + "\n");
            }
            sb.append("-------------------\n");
            return sb.toString();
        }

        public static class PhasingTableEntry
        implements Comparable<PhasingTableEntry> {
            private HaplotypeClass haplotypeClass;
            private PhasingScore score;

            public PhasingTableEntry(HaplotypeClass haplotypeClass, PhasingScore score) {
                this.haplotypeClass = haplotypeClass;
                this.score = score;
            }

            public HaplotypeClass getHaplotypeClass() {
                return this.haplotypeClass;
            }

            public PhasingScore getScore() {
                return this.score;
            }

            @Override
            public int compareTo(PhasingTableEntry that) {
                return this.getScore().compareTo(that.getScore());
            }
        }
    }

    private static class TableCreatorOfHaplotypeAndComplementForDiploidAlleles
    extends HaplotypeTableCreator {
        private SNPallelePair[] SNPallelePairs;
        private int startIndex;
        private int marginalizeLength;

        public TableCreatorOfHaplotypeAndComplementForDiploidAlleles(Genotype[] hetGenotypes, int startIndex, int marginalizeLength) {
            super(hetGenotypes);
            this.SNPallelePairs = new SNPallelePair[this.genotypes.length];
            for (int i = 0; i < this.genotypes.length; ++i) {
                this.SNPallelePairs[i] = new SNPallelePair(this.genotypes[i]);
            }
            this.startIndex = startIndex;
            this.marginalizeLength = marginalizeLength;
        }

        @Override
        public PhasingTable getNewTable() {
            PhasingTable table = new PhasingTable();
            for (Haplotype hap : this.getAllHaplotypes()) {
                if (!this.SNPallelePairs[this.startIndex].matchesTopBase(hap.getBase(this.startIndex))) continue;
                ArrayList<Haplotype> hapList = new ArrayList<Haplotype>();
                hapList.add(hap);
                hapList.add(this.complement(hap));
                Haplotype rep = hap.subHaplotype(this.startIndex, this.startIndex + this.marginalizeLength);
                double hapClassPrior = this.getHaplotypeRepresentativePrior(rep);
                HaplotypeClass hapClass = new HaplotypeClass(hapList, rep);
                table.addEntry(hapClass, hapClassPrior);
            }
            return table;
        }

        private double getHaplotypeRepresentativePrior(Haplotype rep) {
            return 1.0;
        }

        private Haplotype complement(Haplotype hap) {
            int numSites = this.SNPallelePairs.length;
            if (hap.size() != numSites) {
                throw new ReviewedStingException("INTERNAL ERROR: hap.size() != numSites");
            }
            byte[] complementBases = new byte[numSites];
            for (int i = 0; i < numSites; ++i) {
                complementBases[i] = this.SNPallelePairs[i].getOtherBase(hap.getBase(i));
            }
            return new Haplotype(complementBases);
        }
    }

    private static abstract class HaplotypeTableCreator {
        protected Genotype[] genotypes;

        public HaplotypeTableCreator(Genotype[] hetGenotypes) {
            this.genotypes = hetGenotypes;
        }

        public abstract PhasingTable getNewTable();

        protected List<Haplotype> getAllHaplotypes() {
            int numSites = this.genotypes.length;
            int[] genotypeCards = new int[numSites];
            for (int i = 0; i < numSites; ++i) {
                genotypeCards[i] = this.genotypes[i].getPloidy();
            }
            LinkedList<Haplotype> allHaps = new LinkedList<Haplotype>();
            CardinalityCounter alleleCounter = new CardinalityCounter(genotypeCards);
            for (int[] alleleInds : alleleCounter) {
                byte[] hapBases = new byte[numSites];
                for (int i = 0; i < numSites; ++i) {
                    Allele alleleI = this.genotypes[i].getAllele(alleleInds[i]);
                    hapBases[i] = SNPallelePair.getSingleBase(alleleI);
                }
                allHaps.add(new Haplotype(hapBases));
            }
            return allHaps;
        }

        public static PhasingTable marginalizeAsNewTable(PhasingTable table) {
            TreeMap<Haplotype, PreciseNonNegativeDouble> hapMap = new TreeMap<Haplotype, PreciseNonNegativeDouble>();
            for (PhasingTable.PhasingTableEntry pte : table) {
                Haplotype rep = pte.getHaplotypeClass().getRepresentative();
                PreciseNonNegativeDouble score = (PreciseNonNegativeDouble)hapMap.get(rep);
                if (score == null) {
                    score = new PreciseNonNegativeDouble(ZERO);
                    hapMap.put(rep, score);
                }
                score.plusEqual(pte.getScore());
            }
            PhasingTable margTable = new PhasingTable();
            for (Map.Entry hapClassAndScore : hapMap.entrySet()) {
                Haplotype rep = (Haplotype)hapClassAndScore.getKey();
                ArrayList<Haplotype> hapList = new ArrayList<Haplotype>();
                hapList.add(rep);
                HaplotypeClass hc = new HaplotypeClass(hapList, rep);
                margTable.addEntry(hc, (PreciseNonNegativeDouble)hapClassAndScore.getValue());
            }
            return margTable;
        }
    }

    private class UnfinishedVariantContext
    implements HasGenomeLocation {
        private String name;
        private String contig;
        private int start;
        private int stop;
        private Collection<Allele> alleles;
        private Map<String, Genotype> genotypes;
        private double log10PError;
        private Set<String> filters;
        private Map<String, Object> attributes;
        private String id;

        public UnfinishedVariantContext(VariantContext vc) {
            this.name = vc.getSource();
            this.id = vc.getID();
            this.contig = vc.getChr();
            this.start = vc.getStart();
            this.stop = vc.getEnd();
            this.alleles = vc.getAlleles();
            this.genotypes = new HashMap<String, Genotype>();
            for (Genotype g : vc.getGenotypes()) {
                this.genotypes.put(g.getSampleName(), g);
            }
            this.log10PError = vc.getLog10PError();
            this.filters = vc.filtersWereApplied() ? vc.getFilters() : null;
            this.attributes = new HashMap<String, Object>(vc.getAttributes());
        }

        public VariantContext toVariantContext() {
            GenotypesContext gc = GenotypesContext.copy(this.genotypes.values());
            return new VariantContextBuilder(this.name, this.contig, this.start, this.stop, this.alleles).id(this.id).genotypes(gc).log10PError(this.log10PError).filters(this.filters).attributes(this.attributes).make();
        }

        @Override
        public GenomeLoc getLocation() {
            return ReadBackedPhasingWalker.this.getToolkit().getGenomeLocParser().createGenomeLoc(this.contig, this.start, this.stop);
        }

        public Genotype getGenotype(String sample) {
            return this.genotypes.get(sample);
        }

        public void setGenotype(String sample, Genotype newGt) {
            this.genotypes.put(sample, newGt);
        }

        public void setPhasingInconsistent() {
            this.attributes.put(ReadBackedPhasingWalker.PHASING_INCONSISTENT_KEY, true);
        }
    }

    private class UnfinishedVariantAndReads {
        public UnfinishedVariantContext unfinishedVariant;
        public HashMap<String, ReadBasesAtPosition> sampleReadBases;

        public UnfinishedVariantAndReads(VariantAndReads vr) {
            this.unfinishedVariant = new UnfinishedVariantContext(vr.variant);
            this.sampleReadBases = vr.sampleReadBases;
        }
    }

    private class VariantAndReads {
        public VariantContext variant;
        public HashMap<String, ReadBasesAtPosition> sampleReadBases;

        public VariantAndReads(VariantContext variant, HashMap<String, ReadBasesAtPosition> sampleReadBases) {
            this.variant = variant;
            this.sampleReadBases = sampleReadBases;
        }

        public VariantAndReads(VariantContext variant, AlignmentContext alignment) {
            this.variant = variant;
            this.sampleReadBases = new HashMap();
            if (alignment != null) {
                ReadBackedPileup pileup = null;
                if (alignment.hasBasePileup()) {
                    pileup = alignment.getBasePileup();
                } else if (alignment.hasExtendedEventPileup()) {
                    pileup = alignment.getExtendedEventPileup();
                }
                if (pileup != null && (pileup = pileup.getBaseAndMappingFilteredPileup(ReadBackedPhasingWalker.this.MIN_BASE_QUALITY_SCORE, ReadBackedPhasingWalker.this.MIN_MAPPING_QUALITY_SCORE)) != null) {
                    for (String sample : pileup.getSamples()) {
                        ReadBackedPileup samplePileup = pileup.getPileupForSample(sample);
                        ReadBasesAtPosition readBases = new ReadBasesAtPosition();
                        for (PileupElement p : samplePileup) {
                            if (p.isDeletion()) continue;
                            readBases.putReadBase(p);
                        }
                        this.sampleReadBases.put(sample, readBases);
                    }
                }
            }
        }
    }

    private static class MaxHaplotypeAndQuality {
        public PhasingTable.PhasingTableEntry maxEntry;
        public double phaseQuality;

        public MaxHaplotypeAndQuality(PhasingTable hapTable, boolean printDebug) {
            hapTable = HaplotypeTableCreator.marginalizeAsNewTable(hapTable);
            this.calculateMaxHapAndPhasingQuality(hapTable, printDebug);
        }

        private void calculateMaxHapAndPhasingQuality(PhasingTable hapTable, boolean printDebug) {
            hapTable.normalizeScores();
            this.maxEntry = hapTable.maxEntry();
            PreciseNonNegativeDouble sumErrorProbs = new PreciseNonNegativeDouble(ZERO);
            for (PhasingTable.PhasingTableEntry pte : hapTable) {
                if (pte == this.maxEntry) continue;
                sumErrorProbs.plusEqual(pte.getScore());
            }
            this.phaseQuality = -10.0 * sumErrorProbs.getLog10Value();
        }

        public boolean hasSameRepresentativeHaplotype(MaxHaplotypeAndQuality that) {
            return this.getRepresentative().equals(that.getRepresentative());
        }

        private Haplotype getRepresentative() {
            return this.maxEntry.getHaplotypeClass().getRepresentative();
        }
    }

    private class PhasingWindow {
        private Genotype[] hetGenotypes = null;
        private CloneableIteratorLinkedList.CloneableIterator<UnfinishedVariantAndReads> prevHetAndInteriorIt = null;
        private int phasingSiteIndex = -1;
        private Map<String, PhasingRead> readsAtHetSites = null;

        public boolean hasPreviousHets() {
            return this.phasingSiteIndex > 0;
        }

        public PhasingWindow(VariantAndReads vr, String sample) {
            List<GenotypeAndReadBases> listHetGenotypes = new LinkedList<GenotypeAndReadBases>();
            CloneableIteratorLinkedList.CloneableIterator phasedIt = ReadBackedPhasingWalker.this.partiallyPhasedSites.iterator();
            while (phasedIt.hasNext()) {
                UnfinishedVariantAndReads phasedVr = (UnfinishedVariantAndReads)phasedIt.next();
                Genotype gt = phasedVr.unfinishedVariant.getGenotype(sample);
                if (gt == null || !ReadBackedPhasingWalker.isUnfilteredCalledDiploidGenotype(gt)) {
                    listHetGenotypes.clear();
                    continue;
                }
                if (!gt.isHet()) continue;
                GenotypeAndReadBases grb = new GenotypeAndReadBases(gt, phasedVr.sampleReadBases.get(sample), phasedVr.unfinishedVariant.getLocation());
                listHetGenotypes.add(grb);
                this.prevHetAndInteriorIt = phasedIt.clone();
            }
            this.phasingSiteIndex = listHetGenotypes.size();
            if (this.phasingSiteIndex == 0) {
                this.hetGenotypes = null;
                this.prevHetAndInteriorIt = null;
                return;
            }
            this.prevHetAndInteriorIt.previous();
            GenomeLoc phaseLocus = VariantContextUtils.getLocation(ReadBackedPhasingWalker.this.getToolkit().getGenomeLocParser(), vr.variant);
            GenotypeAndReadBases grbPhase = new GenotypeAndReadBases(vr.variant.getGenotype(sample), vr.sampleReadBases.get(sample), phaseLocus);
            listHetGenotypes.add(grbPhase);
            for (VariantAndReads nextVr : ReadBackedPhasingWalker.this.unphasedSiteQueue) {
                Genotype gt;
                if (!ReadBackedPhasingWalker.this.startDistancesAreInWindowRange(vr.variant, nextVr.variant) || (gt = nextVr.variant.getGenotype(sample)) == null || !ReadBackedPhasingWalker.isUnfilteredCalledDiploidGenotype(gt)) break;
                if (!gt.isHet()) continue;
                GenotypeAndReadBases grb = new GenotypeAndReadBases(gt, nextVr.sampleReadBases.get(sample), VariantContextUtils.getLocation(ReadBackedPhasingWalker.this.getToolkit().getGenomeLocParser(), nextVr.variant));
                listHetGenotypes.add(grb);
            }
            this.buildReadsAtHetSites(listHetGenotypes, sample, grbPhase.loc);
            Set<String> onlyKeepReads = this.removeExtraneousReads(listHetGenotypes.size());
            listHetGenotypes = this.removeExtraneousSites(listHetGenotypes);
            if (listHetGenotypes.size() > ReadBackedPhasingWalker.this.maxPhaseSites) {
                listHetGenotypes = this.trimWindow(listHetGenotypes, sample, phaseLocus);
                this.buildReadsAtHetSites(listHetGenotypes, onlyKeepReads);
                onlyKeepReads = this.removeExtraneousReads(listHetGenotypes.size());
                listHetGenotypes = this.removeExtraneousSites(listHetGenotypes);
            }
            this.buildReadsAtHetSites(listHetGenotypes, onlyKeepReads);
            this.hetGenotypes = new Genotype[listHetGenotypes.size()];
            int index = 0;
            for (GenotypeAndReadBases copyGrb : listHetGenotypes) {
                this.hetGenotypes[index++] = copyGrb.genotype;
            }
        }

        private void buildReadsAtHetSites(List<GenotypeAndReadBases> listHetGenotypes, String sample, GenomeLoc phasingLoc) {
            this.buildReadsAtHetSites(listHetGenotypes, sample, phasingLoc, null);
        }

        private void buildReadsAtHetSites(List<GenotypeAndReadBases> listHetGenotypes, Set<String> onlyKeepReads) {
            this.buildReadsAtHetSites(listHetGenotypes, null, null, onlyKeepReads);
        }

        private void buildReadsAtHetSites(List<GenotypeAndReadBases> listHetGenotypes, String sample, GenomeLoc phasingLoc, Set<String> onlyKeepReads) {
            this.readsAtHetSites = new HashMap<String, PhasingRead>();
            int index = 0;
            for (GenotypeAndReadBases grb : listHetGenotypes) {
                ReadBasesAtPosition readBases = grb.readBases;
                if (readBases != null) {
                    for (ReadBase rb : readBases) {
                        String readName = rb.readName;
                        if (onlyKeepReads != null && !onlyKeepReads.contains(readName)) continue;
                        PhasingRead rd = this.readsAtHetSites.get(readName);
                        if (rd == null) {
                            rd = new PhasingRead(listHetGenotypes.size(), rb.mappingQual);
                            this.readsAtHetSites.put(readName, rd);
                        } else if (ReadBackedPhasingWalker.this.outputMultipleBaseCountsWriter != null && rd.getBase(index) != null && sample != null && phasingLoc != null) {
                            ReadBackedPhasingWalker.this.outputMultipleBaseCountsWriter.setMultipleBases(new SampleReadLocus(sample, readName, grb.loc), phasingLoc, rd.getBase(index), rb.base);
                        }
                        rd.updateBaseAndQuality(index, rb.base, rb.baseQual);
                    }
                }
                ++index;
            }
        }

        public Set<String> removeExtraneousReads(int numHetSites) {
            PhasingGraph readGraph = new PhasingGraph(numHetSites);
            EdgeToReads edgeToReads = new EdgeToReads();
            TreeSet<Integer> sitesWithEdges = new TreeSet<Integer>();
            for (Map.Entry<String, PhasingRead> nameToReads : this.readsAtHetSites.entrySet()) {
                String rdName = nameToReads.getKey();
                PhasingRead rd = nameToReads.getValue();
                int[] siteInds = rd.getNonNullIndices();
                for (int i = 0; i < siteInds.length; ++i) {
                    for (int j = i + 1; j < siteInds.length; ++j) {
                        PhasingGraphEdge e = new PhasingGraphEdge(siteInds[i], siteInds[j]);
                        readGraph.addEdge(e);
                        edgeToReads.addRead(e, rdName);
                        sitesWithEdges.add(e.getV1());
                        sitesWithEdges.add(e.getV2());
                    }
                }
            }
            HashSet<String> keepReads = new HashSet<String>();
            int prev = this.phasingSiteIndex - 1;
            int cur = this.phasingSiteIndex;
            if (!readGraph.getConnectedComponents().inSameSet(prev, cur)) {
                this.readsAtHetSites.clear();
                return keepReads;
            }
            IntegerSet[] removedSiteSameCCAsPrev = new IntegerSet[numHetSites];
            IntegerSet[] removedSiteSameCCAsCur = new IntegerSet[numHetSites];
            Iterator<Object> i$ = sitesWithEdges.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                Collection<PhasingGraphEdge> removedEdges = readGraph.removeAllIncidentEdges(i);
                DisjointSet ccAfterRemove = readGraph.getConnectedComponents();
                removedSiteSameCCAsPrev[i] = new IntegerSet(ccAfterRemove.inSameSetAs(prev, sitesWithEdges));
                removedSiteSameCCAsCur[i] = new IntegerSet(ccAfterRemove.inSameSetAs(cur, sitesWithEdges));
                readGraph.addEdges(removedEdges);
            }
            for (PhasingGraphEdge e : readGraph) {
                boolean prevTo1and2ToCur;
                boolean prevTo2and1ToCur = removedSiteSameCCAsPrev[e.getV1()].contains(e.getV2()) && removedSiteSameCCAsCur[e.getV2()].contains(e.getV1());
                boolean bl = prevTo1and2ToCur = removedSiteSameCCAsPrev[e.getV2()].contains(e.getV1()) && removedSiteSameCCAsCur[e.getV1()].contains(e.getV2());
                if (!prevTo2and1ToCur && !prevTo1and2ToCur) continue;
                for (String readName : edgeToReads.getReads(e)) {
                    keepReads.add(readName);
                }
            }
            Iterator<Map.Entry<String, PhasingRead>> readIt = this.readsAtHetSites.entrySet().iterator();
            while (readIt.hasNext()) {
                Map.Entry<String, PhasingRead> nameToReads = readIt.next();
                String rdName = nameToReads.getKey();
                if (keepReads.contains(rdName)) continue;
                readIt.remove();
            }
            return keepReads;
        }

        private List<GenotypeAndReadBases> removeExtraneousSites(List<GenotypeAndReadBases> listHetGenotypes) {
            HashSet<Integer> sitesWithReads = new HashSet<Integer>();
            for (Map.Entry<String, PhasingRead> nameToReads : this.readsAtHetSites.entrySet()) {
                PhasingRead rd = nameToReads.getValue();
                for (int i : rd.getNonNullIndices()) {
                    sitesWithReads.add(i);
                }
            }
            LinkedList<GenotypeAndReadBases> keepHetSites = new LinkedList<GenotypeAndReadBases>();
            int index = 0;
            int numPrecedingRemoved = 0;
            for (GenotypeAndReadBases grb : listHetGenotypes) {
                boolean keepSite = sitesWithReads.contains(index);
                if (keepSite || index == this.phasingSiteIndex || index == this.phasingSiteIndex - 1) {
                    keepHetSites.add(grb);
                    if (!keepSite) {
                        // empty if block
                    }
                } else if (index <= this.phasingSiteIndex) {
                    ++numPrecedingRemoved;
                }
                ++index;
            }
            this.phasingSiteIndex -= numPrecedingRemoved;
            return keepHetSites;
        }

        private List<GenotypeAndReadBases> trimWindow(List<GenotypeAndReadBases> listHetGenotypes, String sample, GenomeLoc phaseLocus) {
            int useOnRight;
            int useOnLeft;
            int halfToUse;
            int prevSiteIndex = this.phasingSiteIndex - 1;
            int numToUse = ReadBackedPhasingWalker.this.maxPhaseSites - 2;
            int numOnLeft = prevSiteIndex;
            int numOnRight = listHetGenotypes.size() - (this.phasingSiteIndex + 1);
            if (numOnLeft <= numOnRight) {
                halfToUse = new Double(Math.floor((double)numToUse / 2.0)).intValue();
                useOnLeft = Math.min(halfToUse, numOnLeft);
                useOnRight = Math.min(numToUse - useOnLeft, numOnRight);
            } else {
                halfToUse = new Double(Math.ceil((double)numToUse / 2.0)).intValue();
                useOnRight = Math.min(halfToUse, numOnRight);
                useOnLeft = Math.min(numToUse - useOnRight, numOnLeft);
            }
            int startIndex = prevSiteIndex - useOnLeft;
            int stopIndex = this.phasingSiteIndex + useOnRight + 1;
            this.phasingSiteIndex -= startIndex;
            listHetGenotypes = listHetGenotypes.subList(startIndex, stopIndex);
            return listHetGenotypes;
        }

        private class IntegerSet
        implements Iterable<Integer> {
            private Set<Integer> list;

            public IntegerSet(Set<Integer> list) {
                this.list = list;
            }

            public boolean contains(int i) {
                return this.list.contains(i);
            }

            @Override
            public Iterator<Integer> iterator() {
                return this.list.iterator();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (int i : this) {
                    sb.append(i + ", ");
                }
                return sb.toString();
            }
        }

        private class EdgeToReads {
            private TreeMap<PhasingGraphEdge, List<String>> edgeReads = new TreeMap();

            public void addRead(PhasingGraphEdge e, String readName) {
                List<String> reads = this.edgeReads.get(e);
                if (reads == null) {
                    reads = new LinkedList<String>();
                    this.edgeReads.put(e, reads);
                }
                reads.add(readName);
            }

            public List<String> getReads(PhasingGraphEdge e) {
                return this.edgeReads.get(e);
            }
        }
    }

    private static class GenotypeAndReadBases {
        public Genotype genotype;
        public ReadBasesAtPosition readBases;
        public GenomeLoc loc;

        public GenotypeAndReadBases(Genotype genotype, ReadBasesAtPosition readBases, GenomeLoc loc) {
            this.genotype = genotype;
            this.readBases = readBases;
            this.loc = loc;
        }
    }
}

