/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.ExactAFCalculationModel;
import org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector.SampleSelector;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class GLBasedSampleSelector
extends SampleSelector {
    Map<Integer, double[][]> numAllelePriorMatrix = new HashMap<Integer, double[][]>();
    double referenceLikelihood;

    public GLBasedSampleSelector(TreeSet<String> sm, double refLik) {
        super(sm);
        this.referenceLikelihood = refLik;
    }

    @Override
    public boolean selectSiteInSamples(VariantContext vc) {
        if (this.samples == null || this.samples.isEmpty()) {
            return true;
        }
        VariantContext subContext = vc.subContextFromSamples(this.samples);
        double[][] flatPrior = this.createFlatPrior(vc.getAlleles());
        AlleleFrequencyCalculationResult result = new AlleleFrequencyCalculationResult(vc.getAlternateAlleles().size(), 2 * this.samples.size());
        ExactAFCalculationModel.linearExactMultiAllelic(subContext.getGenotypes(), vc.getAlternateAlleles().size(), flatPrior, result, true);
        return result.getLog10PosteriorOfAFzero() < this.referenceLikelihood;
    }

    private double[][] createFlatPrior(List<Allele> alleles) {
        if (!this.numAllelePriorMatrix.containsKey(alleles.size())) {
            this.numAllelePriorMatrix.put(alleles.size(), new double[alleles.size()][1 + 2 * this.samples.size()]);
        }
        return this.numAllelePriorMatrix.get(alleles.size());
    }
}

