/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.StateKey;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class VariantEvaluator {
    public void initialize(VariantEvalWalker walker) {
    }

    public abstract boolean enabled();

    public abstract int getComparisonOrder();

    public void update0(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
    }

    public String update1(VariantContext eval, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        return null;
    }

    public String update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        return null;
    }

    public void finalizeEvaluation() {
    }

    protected double rate(long n, long d) {
        return (double)n / (1.0 * (double)Math.max(d, 1L));
    }

    protected long inverseRate(long n, long d) {
        return n == 0L ? 0L : d / Math.max(n, 1L);
    }

    protected double ratio(long num, long denom) {
        return (double)num / (double)Math.max(denom, 1L);
    }

    public boolean stateIsApplicable(StateKey stateKey) {
        return true;
    }
}

