/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class AlleleCount
extends VariantStratifier {
    @Override
    public void initialize() {
        List<RodBinding<VariantContext>> evals = this.getVariantEvalWalker().getEvals();
        if (evals.size() != 1) {
            throw new UserException.BadArgumentValue("AlleleCount", "AlleleCount stratification only works with a single eval vcf");
        }
        int nchrom = this.getVariantEvalWalker().getSampleNamesForEvaluation().size() * 2;
        if (nchrom < 2) {
            throw new UserException.BadArgumentValue("AlleleCount", "AlleleCount stratification requires an eval vcf with at least one sample");
        }
        for (int ac = 0; ac <= nchrom; ++ac) {
            this.states.add(String.format("%d", ac));
        }
        this.getVariantEvalWalker().getLogger().info("AlleleCount using " + nchrom + " chromosomes");
    }

    @Override
    public List<String> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        ArrayList<String> relevantStates = new ArrayList<String>(1);
        if (eval != null) {
            int AC = -1;
            if (eval.hasAttribute("AC") && eval.getAttribute("AC") instanceof Integer) {
                AC = eval.getAttributeAsInt("AC", 0);
            } else if (eval.isVariant()) {
                for (Allele allele : eval.getAlternateAlleles()) {
                    AC = Math.max(AC, eval.getCalledChrCount(allele));
                }
            } else {
                AC = 0;
            }
            relevantStates.add(String.format("%d", AC));
        }
        return relevantStates;
    }
}

