/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class AlleleFrequency
extends VariantStratifier {
    @Override
    public void initialize() {
        this.states = new ArrayList();
        for (double a = 0.0; a <= 1.005; a += 0.005) {
            this.states.add(String.format("%.3f", a));
        }
    }

    @Override
    public List<String> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        ArrayList<String> relevantStates = new ArrayList<String>();
        if (eval != null) {
            try {
                relevantStates.add(String.format("%.3f", 5.0 * MathUtils.round(eval.getAttributeAsDouble("AF", 0.0) / 5.0, 3)));
            }
            catch (Exception e) {
                return relevantStates;
            }
        }
        return relevantStates;
    }
}

