/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.StandardStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class Novelty
extends VariantStratifier
implements StandardStratification {
    private List<RodBinding<VariantContext>> knowns;

    @Override
    public void initialize() {
        this.states = new ArrayList<String>(Arrays.asList("all", "known", "novel"));
        this.knowns = this.getVariantEvalWalker().getKnowns();
    }

    @Override
    public List<String> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        if (tracker != null && eval != null) {
            List knownComps = tracker.getValues(this.knowns, ref.getLocus());
            for (VariantContext c : knownComps) {
                if (eval.getType() != c.getType()) continue;
                return Arrays.asList("all", "known");
            }
        }
        return Arrays.asList("all", "novel");
    }
}

