/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantrecalibration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class Tranche
implements Comparable<Tranche> {
    private static final int CURRENT_VERSION = 4;
    public double ts;
    public double minVQSLod;
    public double knownTiTv;
    public double novelTiTv;
    public int numKnown;
    public int numNovel;
    public String name;
    int accessibleTruthSites = 0;
    int callsAtTruthSites = 0;

    public Tranche(double ts, double minVQSLod, int numKnown, double knownTiTv, int numNovel, double novelTiTv, int accessibleTruthSites, int callsAtTruthSites) {
        this(ts, minVQSLod, numKnown, knownTiTv, numNovel, novelTiTv, accessibleTruthSites, callsAtTruthSites, "anonymous");
    }

    public Tranche(double ts, double minVQSLod, int numKnown, double knownTiTv, int numNovel, double novelTiTv, int accessibleTruthSites, int callsAtTruthSites, String name) {
        this.ts = ts;
        this.minVQSLod = minVQSLod;
        this.novelTiTv = novelTiTv;
        this.numNovel = numNovel;
        this.knownTiTv = knownTiTv;
        this.numKnown = numKnown;
        this.name = name;
        this.accessibleTruthSites = accessibleTruthSites;
        this.callsAtTruthSites = callsAtTruthSites;
        if (ts < 0.0 || ts > 100.0) {
            throw new UserException("Target FDR is unreasonable " + ts);
        }
        if (numKnown < 0 || numNovel < 0) {
            throw new ReviewedStingException("Invalid tranche - no. variants is < 0 : known " + numKnown + " novel " + numNovel);
        }
        if (name == null) {
            throw new ReviewedStingException("BUG -- name cannot be null");
        }
    }

    private double getTruthSensitivity() {
        return this.accessibleTruthSites > 0 ? (double)this.callsAtTruthSites / (1.0 * (double)this.accessibleTruthSites) : 0.0;
    }

    @Override
    public int compareTo(Tranche other) {
        return Double.compare(this.ts, other.ts);
    }

    public String toString() {
        return String.format("Tranche ts=%.2f minVQSLod=%.4f known=(%d @ %.4f) novel=(%d @ %.4f) truthSites(%d accessible, %d called), name=%s]", this.ts, this.minVQSLod, this.numKnown, this.knownTiTv, this.numNovel, this.novelTiTv, this.accessibleTruthSites, this.callsAtTruthSites, this.name);
    }

    public static String tranchesString(List<Tranche> tranches) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(bytes);
        Collections.sort(tranches);
        stream.println("# Variant quality score tranches file");
        stream.println("# Version number 4");
        stream.println("targetTruthSensitivity,numKnown,numNovel,knownTiTv,novelTiTv,minVQSLod,filterName,accessibleTruthSites,callsAtTruthSites,truthSensitivity");
        Tranche prev = null;
        for (Tranche t : tranches) {
            stream.printf("%.2f,%d,%d,%.4f,%.4f,%.4f,TruthSensitivityTranche%.2fto%.2f,%d,%d,%.4f%n", t.ts, t.numKnown, t.numNovel, t.knownTiTv, t.novelTiTv, t.minVQSLod, prev == null ? 0.0 : prev.ts, t.ts, t.accessibleTruthSites, t.callsAtTruthSites, t.getTruthSensitivity());
            prev = t;
        }
        return bytes.toString();
    }

    private static double getDouble(Map<String, String> bindings, String key, boolean required) {
        if (bindings.containsKey(key)) {
            String val = bindings.get(key);
            return Double.valueOf(val);
        }
        if (required) {
            throw new UserException.MalformedFile("Malformed tranches file.  Missing required key " + key);
        }
        return -1.0;
    }

    private static int getInteger(Map<String, String> bindings, String key, boolean required) {
        if (bindings.containsKey(key)) {
            return Integer.valueOf(bindings.get(key));
        }
        if (required) {
            throw new UserException.MalformedFile("Malformed tranches file.  Missing required key " + key);
        }
        return -1;
    }

    public static List<Tranche> readTranches(File f) {
        String[] header = null;
        ArrayList<Tranche> tranches = new ArrayList<Tranche>();
        try {
            for (String line : new XReadLines(f)) {
                if (line.startsWith("#")) continue;
                String[] vals = line.split(",");
                if (header == null) {
                    header = vals;
                    if (header.length == 5 || header.length == 8 || header.length == 11) {
                        throw new UserException.MalformedFile(f, "Unfortunately, your tranches file is from a previous version of this tool and cannot be used with the latest code.  Please rerun VariantRecalibrator");
                    }
                    if (header.length == 10) continue;
                    throw new UserException.MalformedFile(f, "Expected 10 elements in header line " + line);
                }
                if (header.length != vals.length) {
                    throw new UserException.MalformedFile(f, "Line had too few/many fields.  Header = " + header.length + " vals " + vals.length + ". The line was: " + line);
                }
                HashMap<String, String> bindings = new HashMap<String, String>();
                for (int i = 0; i < vals.length; ++i) {
                    bindings.put(header[i], vals[i]);
                }
                tranches.add(new Tranche(Tranche.getDouble(bindings, "targetTruthSensitivity", true), Tranche.getDouble(bindings, "minVQSLod", true), Tranche.getInteger(bindings, "numKnown", false), Tranche.getDouble(bindings, "knownTiTv", false), Tranche.getInteger(bindings, "numNovel", true), Tranche.getDouble(bindings, "novelTiTv", true), Tranche.getInteger(bindings, "accessibleTruthSites", false), Tranche.getInteger(bindings, "callsAtTruthSites", false), (String)bindings.get("filterName")));
            }
            Collections.sort(tranches);
            return tranches;
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(f, (Exception)e);
        }
    }
}

