/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;

public enum NGSPlatform {
    ILLUMINA("ILLUMINA", "SLX", "SOLEXA"),
    SOLID("SOLID"),
    LS454("454"),
    COMPLETE_GENOMICS("COMPLETE"),
    PACBIO("PACBIO"),
    ION_TORRENT("IONTORRENT"),
    UNKNOWN("UNKNOWN");

    private final String[] BAM_PL_NAMES;

    private NGSPlatform(String ... BAM_PL_NAMES) {
        for (int i = 0; i < BAM_PL_NAMES.length; ++i) {
            BAM_PL_NAMES[i] = BAM_PL_NAMES[i].toUpperCase();
        }
        this.BAM_PL_NAMES = BAM_PL_NAMES;
    }

    public final String getDefaultPlatform() {
        return this.BAM_PL_NAMES[0];
    }

    public static final NGSPlatform fromRead(SAMRecord read) {
        return NGSPlatform.fromReadGroup(read.getReadGroup());
    }

    public static final NGSPlatform fromReadGroup(SAMReadGroupRecord rg) {
        return NGSPlatform.fromReadGroupPL(rg.getPlatform());
    }

    public static final NGSPlatform fromReadGroupPL(String plFromRG) {
        if (plFromRG == null) {
            return UNKNOWN;
        }
        String pl = plFromRG.toUpperCase();
        for (NGSPlatform ngsPlatform : NGSPlatform.values()) {
            for (String bamPLName : ngsPlatform.BAM_PL_NAMES) {
                if (!pl.contains(bamPLName)) continue;
                return ngsPlatform;
            }
        }
        return UNKNOWN;
    }

    public static final boolean isKnown(String platform) {
        return NGSPlatform.fromReadGroupPL(platform) != UNKNOWN;
    }
}

