/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class SequenceDictionaryUtils {
    private static boolean ENABLE_LEXICOGRAPHIC_REQUIREMENT_FOR_HUMAN = true;
    private static SAMSequenceRecord CHR1_HG18 = new SAMSequenceRecord("chr1", 247249719);
    private static SAMSequenceRecord CHR2_HG18 = new SAMSequenceRecord("chr2", 242951149);
    private static SAMSequenceRecord CHR10_HG18 = new SAMSequenceRecord("chr10", 135374737);
    private static SAMSequenceRecord CHR1_HG19 = new SAMSequenceRecord("chr1", 249250621);
    private static SAMSequenceRecord CHR2_HG19 = new SAMSequenceRecord("chr2", 243199373);
    private static SAMSequenceRecord CHR10_HG19 = new SAMSequenceRecord("chr10", 135534747);

    public static boolean allowNonFatalIncompabilities(ValidationExclusion.TYPE validationExclusion) {
        return validationExclusion == ValidationExclusion.TYPE.ALLOW_SEQ_DICT_INCOMPATIBILITY || validationExclusion == ValidationExclusion.TYPE.ALL;
    }

    public static void validateDictionaries(Logger logger, ValidationExclusion.TYPE validationExclusion, String name1, SAMSequenceDictionary dict1, String name2, SAMSequenceDictionary dict2) {
        SequenceDictionaryCompatibility type = SequenceDictionaryUtils.compareDictionaries(dict1, dict2);
        switch (type) {
            case IDENTICAL: {
                return;
            }
            case COMMON_SUBSET: {
                return;
            }
            case NO_COMMON_CONTIGS: {
                throw new UserException.IncompatibleSequenceDictionaries("No overlapping contigs found", name1, dict1, name2, dict2);
            }
            case UNEQUAL_COMMON_CONTIGS: {
                List<SAMSequenceRecord> x = SequenceDictionaryUtils.findDisequalCommonContigs(SequenceDictionaryUtils.getCommonContigsByName(dict1, dict2), dict1, dict2);
                SAMSequenceRecord elt1 = x.get(0);
                SAMSequenceRecord elt2 = x.get(1);
                UserException.IncompatibleSequenceDictionaries ex = new UserException.IncompatibleSequenceDictionaries(String.format("Found contigs with the same name but different lengths:\n  contig %s = %s / %d\n  contig %s = %s / %d", name1, elt1.getSequenceName(), elt1.getSequenceLength(), name2, elt2.getSequenceName(), elt2.getSequenceLength()), name1, dict1, name2, dict2);
                if (SequenceDictionaryUtils.allowNonFatalIncompabilities(validationExclusion)) {
                    logger.warn(ex.getMessage());
                    break;
                }
                throw ex;
            }
            case NON_CANONICAL_HUMAN_ORDER: {
                UserException ex = SequenceDictionaryUtils.nonCanonicalHumanContigOrder(dict1) ? new UserException.LexicographicallySortedSequenceDictionary(name1, dict1) : new UserException.LexicographicallySortedSequenceDictionary(name2, dict2);
                if (SequenceDictionaryUtils.allowNonFatalIncompabilities(validationExclusion)) {
                    logger.warn(ex.getMessage());
                } else {
                    throw ex;
                }
            }
            case OUT_OF_ORDER: {
                UserException ex = new UserException.IncompatibleSequenceDictionaries("Order of contigs differences, which is unsafe", name1, dict1, name2, dict2);
                if (SequenceDictionaryUtils.allowNonFatalIncompabilities(validationExclusion)) {
                    logger.warn(ex.getMessage());
                    break;
                }
                throw ex;
            }
            default: {
                throw new ReviewedStingException("Unexpected SequenceDictionaryComparison type: " + (Object)((Object)type));
            }
        }
    }

    public static SequenceDictionaryCompatibility compareDictionaries(SAMSequenceDictionary dict1, SAMSequenceDictionary dict2) {
        if (SequenceDictionaryUtils.nonCanonicalHumanContigOrder(dict1) || SequenceDictionaryUtils.nonCanonicalHumanContigOrder(dict2)) {
            return SequenceDictionaryCompatibility.NON_CANONICAL_HUMAN_ORDER;
        }
        Set<String> commonContigs = SequenceDictionaryUtils.getCommonContigsByName(dict1, dict2);
        if (commonContigs.size() == 0) {
            return SequenceDictionaryCompatibility.NO_COMMON_CONTIGS;
        }
        if (!SequenceDictionaryUtils.commonContigsAreEquivalent(commonContigs, dict1, dict2)) {
            return SequenceDictionaryCompatibility.UNEQUAL_COMMON_CONTIGS;
        }
        if (!SequenceDictionaryUtils.commonContigsAreInOrder(commonContigs, dict1, dict2)) {
            return SequenceDictionaryCompatibility.OUT_OF_ORDER;
        }
        if (commonContigs.size() == dict1.size() && commonContigs.size() == dict2.size()) {
            return SequenceDictionaryCompatibility.IDENTICAL;
        }
        return SequenceDictionaryCompatibility.COMMON_SUBSET;
    }

    private static boolean commonContigsAreEquivalent(Set<String> commonContigs, SAMSequenceDictionary dict1, SAMSequenceDictionary dict2) {
        return SequenceDictionaryUtils.findDisequalCommonContigs(commonContigs, dict1, dict2) == null;
    }

    private static List<SAMSequenceRecord> findDisequalCommonContigs(Set<String> commonContigs, SAMSequenceDictionary dict1, SAMSequenceDictionary dict2) {
        for (String name : commonContigs) {
            SAMSequenceRecord elt2;
            SAMSequenceRecord elt1 = dict1.getSequence(name);
            if (SequenceDictionaryUtils.SequenceRecordsAreEquivalent(elt1, elt2 = dict2.getSequence(name))) continue;
            return Arrays.asList(elt1, elt2);
        }
        return null;
    }

    private static boolean SequenceRecordsAreEquivalent(SAMSequenceRecord me, SAMSequenceRecord that) {
        if (me == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (me.getSequenceLength() != 0 && that.getSequenceLength() != 0 && me.getSequenceLength() != that.getSequenceLength()) {
            return false;
        }
        return me.getSequenceName() == that.getSequenceName();
    }

    private static boolean nonCanonicalHumanContigOrder(SAMSequenceDictionary dict) {
        if (!ENABLE_LEXICOGRAPHIC_REQUIREMENT_FOR_HUMAN) {
            return false;
        }
        SAMSequenceRecord chr1 = null;
        SAMSequenceRecord chr2 = null;
        SAMSequenceRecord chr10 = null;
        for (SAMSequenceRecord elt : dict.getSequences()) {
            if (SequenceDictionaryUtils.isHumanSeqRecord(elt, CHR1_HG18, CHR1_HG19)) {
                chr1 = elt;
            }
            if (SequenceDictionaryUtils.isHumanSeqRecord(elt, CHR2_HG18, CHR2_HG19)) {
                chr2 = elt;
            }
            if (!SequenceDictionaryUtils.isHumanSeqRecord(elt, CHR10_HG18, CHR10_HG19)) continue;
            chr10 = elt;
        }
        if (chr1 != null && chr2 != null && chr10 != null) {
            return chr1.getSequenceIndex() >= chr2.getSequenceIndex() || chr2.getSequenceIndex() >= chr10.getSequenceIndex();
        }
        return false;
    }

    private static boolean isHumanSeqRecord(SAMSequenceRecord elt, SAMSequenceRecord rec1, SAMSequenceRecord rec2) {
        return elt.getSequenceLength() == rec1.getSequenceLength() || elt.getSequenceLength() == rec2.getSequenceLength();
    }

    public static boolean commonContigsAreInOrder(Set<String> commonContigs, SAMSequenceDictionary dict1, SAMSequenceDictionary dict2) {
        List<SAMSequenceRecord> list1 = SequenceDictionaryUtils.sortSequenceListByIndex(SequenceDictionaryUtils.getSequencesOfName(commonContigs, dict1));
        List<SAMSequenceRecord> list2 = SequenceDictionaryUtils.sortSequenceListByIndex(SequenceDictionaryUtils.getSequencesOfName(commonContigs, dict2));
        for (int i = 0; i < list1.size(); ++i) {
            SAMSequenceRecord elt1 = list1.get(i);
            SAMSequenceRecord elt2 = list2.get(i);
            if (elt1.getSequenceName().equals(elt2.getSequenceName())) continue;
            return false;
        }
        return true;
    }

    private static List<SAMSequenceRecord> getSequencesOfName(Set<String> commonContigs, SAMSequenceDictionary dict) {
        ArrayList<SAMSequenceRecord> l = new ArrayList<SAMSequenceRecord>(commonContigs.size());
        for (String name : commonContigs) {
            l.add(dict.getSequence(name));
        }
        return l;
    }

    private static List<SAMSequenceRecord> sortSequenceListByIndex(List<SAMSequenceRecord> unsorted) {
        Collections.sort(unsorted, new CompareSequenceRecordsByIndex());
        return unsorted;
    }

    public static Set<String> getCommonContigsByName(SAMSequenceDictionary dict1, SAMSequenceDictionary dict2) {
        Set<String> intersectingSequenceNames = SequenceDictionaryUtils.getContigNames(dict1);
        intersectingSequenceNames.retainAll(SequenceDictionaryUtils.getContigNames(dict2));
        return intersectingSequenceNames;
    }

    public static Set<String> getContigNames(SAMSequenceDictionary dict) {
        HashSet<String> contigNames = new HashSet<String>((int)((float)dict.size() / 0.75f) + 1, 0.75f);
        for (SAMSequenceRecord dictionaryEntry : dict.getSequences()) {
            contigNames.add(dictionaryEntry.getSequenceName());
        }
        return contigNames;
    }

    private static class CompareSequenceRecordsByIndex
    implements Comparator<SAMSequenceRecord> {
        private CompareSequenceRecordsByIndex() {
        }

        @Override
        public int compare(SAMSequenceRecord x, SAMSequenceRecord y) {
            return new Integer(x.getSequenceIndex()).compareTo(y.getSequenceIndex());
        }
    }

    public static enum SequenceDictionaryCompatibility {
        IDENTICAL,
        COMMON_SUBSET,
        NO_COMMON_CONTIGS,
        UNEQUAL_COMMON_CONTIGS,
        NON_CANONICAL_HUMAN_ORDER,
        OUT_OF_ORDER;

    }
}

