/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import javax.xml.stream.events.StartElement;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.InputNodeMap;
import org.simpleframework.xml.stream.InputPosition;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.NodeReader;
import org.simpleframework.xml.stream.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputElement
implements InputNode {
    private StartElement element;
    private InputNodeMap map;
    private NodeReader reader;
    private InputNode parent;

    public InputElement(InputNode parent, NodeReader reader, StartElement element) {
        this.map = new InputNodeMap(this, element);
        this.element = element;
        this.reader = reader;
        this.parent = parent;
    }

    @Override
    public InputNode getParent() {
        return this.parent;
    }

    @Override
    public Position getPosition() {
        return new InputPosition(this.element);
    }

    @Override
    public String getName() {
        return this.element.getName().getLocalPart();
    }

    @Override
    public String getPrefix() {
        return this.element.getName().getPrefix();
    }

    @Override
    public String getReference() {
        return this.element.getName().getNamespaceURI();
    }

    @Override
    public boolean isRoot() {
        return this.reader.isRoot(this);
    }

    @Override
    public boolean isElement() {
        return true;
    }

    @Override
    public InputNode getAttribute(String name) {
        return this.map.get(name);
    }

    @Override
    public NodeMap<InputNode> getAttributes() {
        return this.map;
    }

    @Override
    public String getValue() throws Exception {
        return this.reader.readValue(this);
    }

    @Override
    public InputNode getNext() throws Exception {
        return this.reader.readElement(this);
    }

    @Override
    public InputNode getNext(String name) throws Exception {
        return this.reader.readElement(this, name);
    }

    @Override
    public void skip() throws Exception {
        this.reader.skipElement(this);
    }

    @Override
    public boolean isEmpty() throws Exception {
        if (!this.map.isEmpty()) {
            return false;
        }
        return this.reader.isEmpty(this);
    }
}

