/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.io.File;
import org.broadinstitute.sting.commandline.ArgumentMatchSourceType;

public class ArgumentMatchSource
implements Comparable<ArgumentMatchSource> {
    public static final ArgumentMatchSource COMMAND_LINE = new ArgumentMatchSource(ArgumentMatchSourceType.CommandLine, null);
    private final ArgumentMatchSourceType type;
    private final File file;

    public ArgumentMatchSource(File file) {
        this(ArgumentMatchSourceType.File, file);
    }

    private ArgumentMatchSource(ArgumentMatchSourceType type, File file) {
        if (type == ArgumentMatchSourceType.File && file == null) {
            throw new IllegalArgumentException("An argument match source of type File cannot have a null file.");
        }
        this.type = type;
        this.file = file;
    }

    public ArgumentMatchSourceType getType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentMatchSource that = (ArgumentMatchSource)o;
        return this.type == that.type && (this.file == null ? that.file == null : this.file.equals(that.file));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ArgumentMatchSource that) {
        File f2;
        int comp = this.type.compareTo(that.type);
        if (comp != 0) {
            return comp;
        }
        File f1 = this.file;
        if (f1 == null ^ (f2 = that.file) == null) {
            return f1 == null ? -1 : 1;
        }
        return f1 == null ? 0 : f1.compareTo(f2);
    }
}

