/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentIOType;
import org.broadinstitute.sting.commandline.ArgumentMatch;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public abstract class ArgumentTypeDescriptor {
    private static Class[] ARGUMENT_ANNOTATIONS = new Class[]{Input.class, Output.class, Argument.class};
    protected static Logger logger = Logger.getLogger(ArgumentTypeDescriptor.class);

    public static ArgumentTypeDescriptor selectBest(Collection<ArgumentTypeDescriptor> descriptors, Class type) {
        for (ArgumentTypeDescriptor descriptor : descriptors) {
            if (!descriptor.supports(type)) continue;
            return descriptor;
        }
        throw new ReviewedStingException("Can't process command-line arguments of type: " + type.getName());
    }

    public abstract boolean supports(Class var1);

    public boolean createsTypeDefault(ArgumentSource source) {
        return false;
    }

    public String typeDefaultDocString(ArgumentSource source) {
        throw new UnsupportedOperationException();
    }

    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        throw new UnsupportedOperationException("Unable to create default for type " + this.getClass());
    }

    public List<ArgumentDefinition> createArgumentDefinitions(ArgumentSource source) {
        return Collections.singletonList(this.createDefaultArgumentDefinition(source));
    }

    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, ArgumentMatches matches) {
        return this.parse(parsingEngine, source, source.field.getGenericType(), matches);
    }

    public boolean isMultiValued(ArgumentSource source) {
        Class<?> argumentType = source.field.getType();
        return Collection.class.isAssignableFrom(argumentType) || argumentType.isArray();
    }

    protected ArgumentDefinition createDefaultArgumentDefinition(ArgumentSource source) {
        Annotation argumentAnnotation = ArgumentTypeDescriptor.getArgumentAnnotation(source);
        return new ArgumentDefinition(ArgumentIOType.getIOType(argumentAnnotation), source.field.getType(), ArgumentDefinition.getFullName(argumentAnnotation, source.field.getName()), ArgumentDefinition.getShortName(argumentAnnotation), ArgumentDefinition.getDoc(argumentAnnotation), source.isRequired() && !this.createsTypeDefault(source) && !source.isFlag() && !source.isDeprecated(), source.isFlag(), source.isMultiValued(), source.isHidden(), this.makeRawTypeIfNecessary(this.getCollectionComponentType(source.field)), ArgumentDefinition.getExclusiveOf(argumentAnnotation), ArgumentDefinition.getValidationRegex(argumentAnnotation), this.getValidOptions(source));
    }

    protected Type getCollectionComponentType(Field field) {
        return null;
    }

    public abstract Object parse(ParsingEngine var1, ArgumentSource var2, Type var3, ArgumentMatches var4);

    protected List<String> getValidOptions(ArgumentSource source) {
        if (!source.field.getType().isEnum()) {
            return null;
        }
        ArrayList<String> validOptions = new ArrayList<String>();
        for (Object constant : source.field.getType().getEnumConstants()) {
            validOptions.add(constant.toString());
        }
        return validOptions;
    }

    protected boolean argumentIsPresent(ArgumentDefinition definition, ArgumentMatches matches) {
        for (ArgumentMatch match : matches) {
            if (!match.definition.equals(definition)) continue;
            return true;
        }
        return false;
    }

    protected String getArgumentValue(ArgumentDefinition definition, ArgumentMatches matches) {
        Collection<String> argumentValues = this.getArgumentValues(definition, matches);
        if (argumentValues.size() > 1) {
            throw new UserException.CommandLineException("Multiple values associated with given definition, but this argument expects only one: " + definition.fullName);
        }
        return argumentValues.size() > 0 ? argumentValues.iterator().next() : null;
    }

    protected Tags getArgumentTags(ArgumentMatches matches) {
        Tags tags = new Tags();
        for (ArgumentMatch match : matches) {
            if (!tags.isEmpty() && !match.tags.isEmpty()) {
                throw new ReviewedStingException("BUG: multiple conflicting sets of tags are available, and the type descriptor specifies no way of resolving the conflict.");
            }
            tags = match.tags;
        }
        return tags;
    }

    protected Collection<String> getArgumentValues(ArgumentDefinition definition, ArgumentMatches matches) {
        ArrayList<String> values = new ArrayList<String>();
        for (ArgumentMatch match : matches) {
            if (!match.definition.equals(definition)) continue;
            values.addAll(match.values());
        }
        return values;
    }

    protected static Annotation getArgumentAnnotation(ArgumentSource source) {
        for (Class annotation : ARGUMENT_ANNOTATIONS) {
            if (!source.field.isAnnotationPresent(annotation)) continue;
            return source.field.getAnnotation(annotation);
        }
        throw new ReviewedStingException("ArgumentAnnotation is not present for the argument field: " + source.field.getName());
    }

    public static boolean isArgumentAnnotationPresent(Field field) {
        for (Class annotation : ARGUMENT_ANNOTATIONS) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArgumentHidden(Field field) {
        return field.isAnnotationPresent(Hidden.class);
    }

    public Class makeRawTypeIfNecessary(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        throw new IllegalArgumentException("Unable to determine Class-derived component type of field: " + t);
    }
}

