/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class DownsamplingMethod {
    public final DownsampleType type;
    public final Integer toCoverage;
    public final Double toFraction;
    public static final DownsamplingMethod NONE = new DownsamplingMethod(DownsampleType.NONE, null, null);

    public DownsamplingMethod(DownsampleType type, Integer toCoverage, Double toFraction) {
        if (type != DownsampleType.NONE && toFraction == null && toCoverage == null) {
            throw new UserException.CommandLineException("Must specify either toFraction or toCoverage when downsampling.");
        }
        if (toFraction != null && toCoverage != null) {
            throw new UserException.CommandLineException("Downsampling coverage and fraction are both specified.  Please choose only one.");
        }
        if (type == DownsampleType.BY_SAMPLE && toFraction != null) {
            throw new UserException.CommandLineException("Cannot downsample to fraction with new EXPERIMENTAL_BY_SAMPLE method");
        }
        this.type = type;
        this.toCoverage = toCoverage;
        this.toFraction = toFraction;
    }
}

